// Method_Request_Shutdown.cpp,v 1.8 2005/01/05 11:47:19 jwillemsen Exp

#include "Method_Request_Shutdown.h"
#include "ThreadPool_Task.h"

ACE_RCSID(Notify, TAO_Notify_Method_Request_Shutdown, "Method_Request_Shutdown.cpp,v 1.8 2005/01/05 11:47:19 jwillemsen Exp")

TAO_Notify_Method_Request_Shutdown::TAO_Notify_Method_Request_Shutdown (TAO_Notify_ThreadPool_Task* task)
  : task_ (task)
{
}

TAO_Notify_Method_Request_Shutdown::~TAO_Notify_Method_Request_Shutdown ()
{
}

TAO_Notify_Method_Request_Queueable*
TAO_Notify_Method_Request_Shutdown::copy (void)
{
  return new TAO_Notify_Method_Request_Shutdown (this->task_);
}

int
TAO_Notify_Method_Request_Shutdown::execute (ACE_ENV_SINGLE_ARG_DECL_NOT_USED)
{
  // Shut down the scheduler by deactivating the activation queue's
  // underlying message queue - should pop all worker threads off their
  // wait and they'll exit.
  this->task_->msg_queue ()->deactivate ();
  return -1;
}
