// -*- C++ -*-

//=============================================================================
/**
 *  @file    TypeCode_SArg_Traits.h
 *
 *  TypeCode_SArg_Traits.h,v 1.3 2005/03/30 13:53:15 jwillemsen Exp
 *
 *  @author  Ossama Othman
 */
//=============================================================================

#ifndef TAO_TYPECODE_SARG_TRAITS_H
#define TAO_TYPECODE_SARG_TRAITS_H

#include /**/ "ace/pre.h"

#include "tao/CORBA_methods.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/PortableServer/Object_SArgument_T.h"
#include "tao/Pseudo_VarOut_T.h"


namespace CORBA
{
  class TypeCode;
  typedef TypeCode *TypeCode_ptr;

  typedef TAO_Pseudo_Var_T<TypeCode> TypeCode_var;
  typedef TAO_Pseudo_Out_T<TypeCode, TypeCode_var> TypeCode_out;
}

// --------------------------------------------------------------

namespace TAO
{
  template <typename T> class SArg_Traits;

  /// Used in generated code if CORBA::TypeCode is an argument or
  /// return type.
  template<>
  class TAO_PortableServer_Export SArg_Traits<CORBA::TypeCode>
    : public Object_SArg_Traits_T<CORBA::TypeCode_ptr,
                                  CORBA::TypeCode_var,
                                  CORBA::TypeCode_out>
  {
  };
}

#include /**/ "ace/post.h"

#endif /* TAO_TYPECODE_SARG_TRAITS_H */
