/*
 * acon a utility to facilitate the right to left writing
 * Copyright 1999 Ahmed Abdel-Hamid Mohamed <ahmedam@mail.usa.com>
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 675 Mass
 * Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <linux/vt.h>
#include <dirent.h>
#include "acon.h"
#include "render.h"
#include "child.h"

#define COLORN 31
#define COLORS 63
#define COLORE 127

int consoleswitched=0;
void putlinexy(int vcsa,int x,int y,char *s,int length)
{
	if(getmaxy()<=y)return;
	if(getmaxx()<=x)return;
	if(x+length>=getmaxx())length=getmaxx()-x;
	processline(s+2,length*2-4);
	lseek(vcsa,4+2*(y*getmaxx()+x),0);
	write(vcsa,s,length*2);
}

void clrscr(int vcsa)
{
	char line[400];
	int i;
	
	memset(line,0,400);
	for(i=0;i<getmaxy();i++)
		putlinexy(vcsa,0,i,line,getmaxx());
}

int drawmenuxy(int vcsa,int x,int y,int xwidth,int ywidth,char **menu,int num)
{
	int i,z,starty=0,select=0;
	unsigned char line[400];
	int ch;
	int currentconsole;

	currentconsole=getactive();

	while(1)
	{
		line[0]=0x86;
		line[1]=COLORN;
		for(i=2;i<xwidth*2+2;i+=2)
			line[i]=0x81,line[i+1]=COLORN;
		line[i]=0x85;
		line[i+1]=COLORN;
		putlinexy(vcsa,x-1,y-1,line,xwidth+2);

		line[0]=0x80;
		line[i]=0x80;
		for(i=0;i<ywidth;i++)
		{
			
			if(i+starty<num)
				for(z=0;z<xwidth*2;z+=2)
				{
					if(z/2<strlen(menu[i+starty]))
						line[z+2]=menu[i+starty][z/2];
					else
						line[z+2]=' ';
					line[z+3]=(i+starty==select?COLORS:COLORN);
				}
			else
				for(z=0;z<xwidth*2;z+=2)
				{
					line[z+2]=' ';
					line[z+3]=(i+starty==select?COLORS:COLORN);
				}

			putlinexy(vcsa,x-1,y+i,line,xwidth+2);
		}
		line[0]=0x84;
		line[1]=COLORN;
		for(i=2;i<xwidth*2+2;i+=2)
			line[i]=0x81,line[i+1]=COLORN;
		line[i]=0x83;
		line[i+1]=COLORN;
		putlinexy(vcsa,x-1,y+ywidth,line,xwidth+2);

		do
		{
			ch=getch();
/*			if(ch!=256)printf("chr = %d \n",ch);*/
			switch(ch)
			{
				case 'u':
				case 65:	/*up*/
					if(select>0)select--;
					else select=num-1;
					break;
				case 'n':
				case 66:	/*down*/
					if(select<num-1)select++;
					else select=0;
					break;
				case 13:	/*Enter*/
				case ' ':
					return select;
				case 'r':
				case 3:
					return -1;
			}

		/*if the active console is changed*/
			if(	currentconsole!=getactive())
			{
				consoleswitched=1;
				return -1;
			}

		}while(ch==256);
		
		if(select>starty+ywidth-1)starty++;
		if(select<starty)starty--;
	}
}

char *getfile(int vcsa,char *path)
{
	DIR *dp;
	struct dirent *ep;
	int i,len,selected;
	char **menu;

	len=0;
	if((dp=opendir(path))==NULL)
		return NULL;
	while((ep=readdir(dp)))
		if(ep->d_type!=DT_DIR && ep->d_name[0]!='.')len++;
	closedir(dp);
	if(len==0)return NULL;

	menu=malloc((len+1)*sizeof(char *));

	if((dp=opendir(path))==NULL)
		return NULL;
	i=1;
	menu[0]=malloc(strlen("<default>")+1);
	strcpy(menu[0],"<default>");
	
	while((ep=readdir(dp)))
	{
		if(ep->d_type==DT_DIR || ep->d_name[0]=='.')continue;
		
		menu[i]=malloc(strlen(ep->d_name)+1);
		if(!menu[i])
		{
			printf("menu.c:Error alocating memory\n");
			return NULL;
		}
		strcpy(menu[i],ep->d_name);
		i++;
	}
	closedir(dp);

	selected=drawmenuxy(vcsa,10,10,30,10,menu,i);

	for(i=0;i<len;i++)
		if(i!=selected)
			free(menu[i]);

	if(selected==-1)
		return NULL;
	if(selected==0)
	{
		free(menu[0]);
		return NULL;
	}
	
	return menu[selected];
}

void gotoxy(int vcsa,int x,int y)
{
	lseek(vcsa,2,SEEK_SET);
	write(vcsa,&x,1);
	write(vcsa,&y,1);
}

char *getuserinput(int vcsa,const char *p,char *str)
{
	unsigned char line[400];
	int ypos;
	int xwidth;
	int ch,i,startpos;
	int currentconsole;

	currentconsole=getactive();
	str[0]=0;
	ypos=getmaxy()/2-2;
	xwidth=getmaxx()-10;
	
	line[0]=0x86;
	line[1]=COLORN;
	for(i=2;i<xwidth*2-2;i+=2)
		line[i]=0x81,line[i+1]=COLORN;
	line[i]=0x85;
	line[i+1]=COLORN;
	putlinexy(vcsa,5,ypos,line,xwidth+2);

	line[0]=0x84;
	for(i=2;i<xwidth*2-2;i+=2)
		line[i]=0x81;
	line[i]=0x83;
	putlinexy(vcsa,5,ypos+2,line,xwidth+2);

	line[0]=0x80;
	line[i]=0x80;
	for	(i=0;i<strlen(p)*2;i+=2)
		line[i+2]=p[i/2];

	startpos=i+2;
	for(i=startpos;i<xwidth*2-2;i+=2)
		line[i+1]=COLORE;
	while(1)
	{
		for(i=startpos;i<xwidth*2-2;i+=2)
			line[i]=' ';
		for(i=0;i<strlen(str);i++)
			line[i*2+startpos]=str[i];
		putlinexy(vcsa,5,ypos+1,line,xwidth+2);
		gotoxy(vcsa,5+startpos/2+strlen(str),ypos+1);
		do
		{
			ch=getch();
			switch(ch)
			{
				case 13:	/*Enter*/
					return str;
				case 3:
					return NULL;
				case 127:
					if(*str)
						str[strlen(str)-1]=0;
					break;
				default:
					str[strlen(str)+1]=0;
					str[strlen(str)]=ch;
			}

		/*if the active console is changed*/
			if(	currentconsole!=getactive())
			{
				consoleswitched=1;
				return NULL;
			}

		}while(ch==256);
	}
}

void options(int vcsa)
{
	char *menu[]={"General direction","Hendi numbers"
		,"UTF-8"
#ifdef LOADFONT
		,"Font file"
#else
		,"---------"
#endif
		,"Translation file"
#ifdef USELOADKEYS
		,"Keymap file"
#else
		,"---------"
#endif
		,"Add console"
		,"Remove this console","Refresh"
		,"Save","Quit"};
	char *directionmenu[]={"LTR 'English'","RTL 'Arabic'"};
	char *hendimenu[]={"Never","Always","By context"};
	char *unicodemenu[]={"Disable","Enable"};
	char tmp[200];
	int selection,z;
	char *s;
	consoleswitched=0;

	clrscr(vcsa);
	
	selection=drawmenuxy(vcsa,5,2,getmaxx()-20,getmaxy()-6,menu,11);
	if(consoleswitched)return;
	switch(selection)
	{
		case 0:	/*Direction*/
			z=drawmenuxy(vcsa,10,4,17,2,directionmenu,2);
			if(z==0 || z==1)setdirection(z);
			break;
		case 1:	/*Hendi numbers*/
			z=drawmenuxy(vcsa,10,5,17,3,hendimenu,3);
			if(z!=-1)setconsolehendi(getconsolenum(),z);
			break;
		case 2:	/*Unicode*/
			z=drawmenuxy(vcsa,10,5,17,2,unicodemenu,2);
			if(z!=-1)setconsoleunicode(getconsolenum(),z);
			refreshconsole();
			break;
#ifdef LOADFONT
		case 3:	/*Font file*/
			s=getfile(vcsa,DATAPATH "/fonts");
			if(!consoleswitched)
			{
				setconsolefont(getconsolenum(),s);
				free(s);
			}
			refreshconsole();
			break;
#endif
		case 4:	/*Translation file*/
			s=getfile(vcsa,DATAPATH "/translations");
			if(!consoleswitched)
			{
				setconsoletranslation(getconsolenum(),s);
				free(s);
			}
			refreshconsole();
			break;
#ifdef USELOADKEYS
		case 5:	/*Keymap file*/
			s=getfile(vcsa,DATAPATH "/keymaps");
			if(!consoleswitched)
			{
				setconsolekeymap(getconsolenum(),s);
				free(s);
			}
			refreshconsole();
			break;
#endif
		case 6: /*Add console*/
			if(getuserinput(vcsa,"Console number:",tmp))
				if(tmp[0])
					addconsole(atoi(tmp));
			break;
		case 7:	/*Remove this console*/
			removeconsole(getconsolenum());
			break;
		case 8:	/*Refresh*/
			refreshconsole();
			break;
		case 9:	/*Save*/
			saveconfiguration();
			break;
		case 10:	/*Quit*/
			consolesn=0;
			break;
		case -1:
			return;
	}
}
