/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/** \file **/
#ifndef CELL_LISTHANDLER
#define CELL_LISTHANDLER

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include <time.h>
#include "Base/AdVector.h"
#include "Base/AdSorter.h"
#include "Base/AdLinkedList.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunMemoryManager.h"
#include "AdunKernel/AdunNonBondedListHandler.h"

/**
Creates an interaction list for a set of non bonded interactions
using a cell space model.
\todo Coding
\ingroup Cinter
**/

@interface CellListHandler: AdNonBondedListHandler
{
	BOOL cellsInitialised;
	BOOL listCreated;
	int numberOfCells;
	int baseSize;		//The initial size of each array in cellContentsMatrix
	int* cellsPerAxis;
	int* cellNumber;	//An array containing the number of the cell each atom is in
	double cellSize;
	double cutoff;
	double maxSpaceSize;
	double cutoff_sq;
	double cellCut;
	double inCut;
	double diagonal;	
	AdMatrix* coordinates;
	AdMatrix* cellCenterMatrix;	//A matrix of the coordinates of the centers of each cell
	AdMatrix* cellIndexMatrix;	//A matrix of the indexes of each cell
	IntMatrix* atomCells;		//A matrix of the indexes of the cell each atom is in.
	Vector3D originCellCenter;	//The coordinates of the center of cell (0,0,0)
	Vector3D minSpaceBoundry;	//The (-,-,-) extremity of the cell space
	Vector3D maxSpaceBoundry;	//The (+,+,+) extremity of the cell space
	Vector3D cellSpaceDimensions;	//The dimension of the cell space
	IntArrayStruct* cellNeighbourMatrix;	
	IntArrayStruct* cellContentsMatrix;	
	IntArrayStruct* updateCheckInteractions; //The interactions that are to be checked in each update step
	AdLinkedList* nonbondedList;
	InterTable* parameters;
	ListElement* (*getElement)(id, SEL);
	NSArray* interactions;
	AdMemoryManager* memoryManager;
}
@end

/**
Category containing methods for creating and
destroying the cell space
*/

@interface CellListHandler (CellMaintainence)
- (void) initialiseCells;
- (void) clearCellMatrices;
@end


#endif 

