/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "AdunKernel/AdunForceField.h"

@class EnzymixForceField;

@implementation AdForceField

+ (id) objectForEnvironment: (id) object observes: (BOOL) value
{
	//there is only one force field type at the moment

	return [[[EnzymixForceField alloc] initWithEnvironment: object observe: value] autorelease];
}

+ (id) objectForEnvironment: (id) object 
{
	return [[[EnzymixForceField alloc] initWithEnvironment: object observe: YES] autorelease];
}

- (id) initWithEnvironment: (id) object observe: (BOOL) value
{
	self = [super initWithEnvironment: object observe: value];

	return self;
}

- (id) initWithEnvironment: (id) object
{
	return [self initWithEnvironment: object observe: YES];
}

- (void) dealloc
{
	[super dealloc];
}

- (void) calculateForces
{
	[NSException raise: NSInternalInconsistencyException
		format: [NSString stringWithFormat:
		@"(%@) %@ is an abstract method. You need to use a concrete subclass of this class", 
		NSStringFromClass([self class]), NSStringFromSelector(_cmd)]];
}

- (id) calculatePotential
{
	[NSException raise: NSInternalInconsistencyException
		format: [NSString stringWithFormat:
		@"(%@) %@ is an abstract method. You need to use a concrete subclass of this class", 
		NSStringFromClass([self class]), NSStringFromSelector(_cmd)]];
}

- (id) calculatePotentialAndUpdateSystem
{
	[NSException raise: NSInternalInconsistencyException
		format: [NSString stringWithFormat:
		@"(%@) %@ is an abstract method. You need to use a concrete subclass of this class", 
		NSStringFromClass([self class]), NSStringFromSelector(_cmd)]];
}

- (id) system
{
	[NSException raise: NSInternalInconsistencyException
		format: [NSString stringWithFormat:
		@"(%@) %@ is an abstract method. You need to use a concrete subclass of this class", 
		NSStringFromClass([self class]), NSStringFromSelector(_cmd)]];
}

- (void) setSystem: (id) object
{
	[NSException raise: NSInternalInconsistencyException
		format: [NSString stringWithFormat:
		@"(%@) %@ is an abstract method. You need to use a concrete subclass of this class", 
		NSStringFromClass([self class]), NSStringFromSelector(_cmd)]];
}

@end


