/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#include "AdunKernel/AdunNonbondedCalculator.h"

@class ShiftedNonBondedCalculator;
@class PureNonBondedCalculator;
@class GRFNonbondedCalculator;

@implementation AdNonbondedCalculator

+ (id) objectForEnvironment: (id) object
{
	if(object == nil)
	{
		return [[PureNonBondedCalculator new] autorelease];
	}
	else
	{
		if([[object valueForKey:@"ShortRangeInteractions"] isEqual: @"Shifted"])
			return [[[ShiftedNonBondedCalculator alloc] initWithEnvironment: object observe: YES] autorelease];
		else if([[object valueForKey:@"ShortRangeInteractions"] isEqual: @"GRF"])
			return [[[GRFNonbondedCalculator alloc] initWithEnvironment: object observe: YES] autorelease];
		else
			return [[[PureNonBondedCalculator alloc] initWithEnvironment: object observe: YES] autorelease];
	}	
}

+ (id) objectForEnvironment: (id) object observes: (BOOL) value
{
	if(object == nil)
	{
		return [[PureNonBondedCalculator new] autorelease];
	}
	else
	{
		if([[object valueForKey:@"ShortRangeInteractions"] isEqual: @"Shifted"])
			return [[[ShiftedNonBondedCalculator alloc] initWithEnvironment: object observe: value] autorelease];
		else if([[object valueForKey:@"ShortRangeInteractions"] isEqual: @"GRF"])
			return [[[GRFNonbondedCalculator alloc] initWithEnvironment: object observe: value] autorelease];
		else
			return [[[PureNonBondedCalculator alloc] initWithEnvironment: object observe: value] autorelease];
	}	
}

- (id) initWithEnvironment: (id) object
{
	return self;
}

- (void) evaluateElectrostaticForces
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) evaluateVDWForces
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setInteractions: (NSValue*) interactions
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) setCoordinates: (NSValue*) value
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) useInternalForceMatrix
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (void) useExternalForceMatrix: (AdMatrix*) forceMatrix
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (double) VDWPotential
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

- (double) ElectrostaticPotential
{
	printf("Object %@: Method %@\n", [self description], NSStringFromSelector(_cmd));
	printf("All subclasses must provide their own implementation of this method\n");
	exit(2);
}

@end
