/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef AD_CREATION
#define AD_CREATION
#include <Foundation/Foundation.h>

/**
Most framework objects can use the information contained in an AdEnvironment object
to initiaise themselves. Using an AdEnvironment object allows you to create a set of objects all initialised
from the same data.

The AdEnvironment object contains a subset (which can be all of them) of the arguements that are present in 
each framwork objects designated initialiser.  This information is retreived by the object from the environment 
(using optionsForDomain: see AdEnvironment for more) 
and used to call the designated initialiser. Nil arguements should be dealt with in the standard way.

\ingroup Protocols
**/

@protocol AdCreation
/**
Equivalent to initWithEnvironment:observe with observe set to YES. 
*/
- (id) initWithEnvironment: (id) object;
/**
If envrionment is nil this has  the same as effect as init (which may or may not be supported)
*/
- (id) initWithEnvironment: (id) object observe: (BOOL) value;
@end

/**
Protocol adopted by abstract framework classes who can return instances of different concrete
subclasses depending on the environment
\ingroup Protocols
**/

@protocol AdAbstractFactory
/**
Equivalent to objectForEnvironment:observes with observes set to YES
*/
+ (id) objectForEnvironment: (id) object;
/**
Returns an autoreleased instance of a subclass of the reciever. The exact subclass is determined by the value of \e object.
If \e object is nil then a default subclass instance is returned. The object returned uses \e object for it envrionment
(if object is not nil) and has an observation state determined by \e value. 
*/
+ (id) objectForEnvironment: (id) object observes: (BOOL) value;
@end

#endif
