/*
   Project: AdunServer

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-31 15:42:33 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ADSERVERINTERFACE_
#define _ADSERVERINTERFACE_

/**
\ingroup Protocols
Contains methods that can be sent from the Kernel to a remote server.
**/

@protocol AdServerInterface <NSObject>
/**
Returns the systems to be used in the simulation identified by \e pid
*/
- (id) getSystemsForProcess: (int) pid;
/**
Returns the options for the simulation identified by \e pid
*/
- (bycopy id) getOptionsForProcess: (int) pid;
/**
Kernel processes establish two way communciation with the server using this method.
\param object An interface object which conforms to the AdCommandInterface protocol
\param pid The process identifier of the kernel instance sending the message
*/
- (void) useInterface: (id) object forProcess: (int) pid;
/**
Tells the server to close the connection to the process identified by the \e pid arguement. 
This method should be sent to the server by kernel processes when they are about to exit. 
\param pid The process identifier of the process requesting that its connection be closed
\param error An NSError object describing why the process is exiting if it is doing so due to some
internal problem. If not i.e. if it is exiting normally, then this parameter should be nil.
*/
- (void) closeConnectionForProcess: (int) pid error: (bycopy NSError*) error;
/**
Kernel process must send this messages when they are ready to accept command requests from the server.
\param pid The process identifier of the simulation that is ready to accept requests.
*/
- (void) acceptingRequests: (int) pid;
/**
Kernel processes use this method to send any datasets generated by controllers back
to the interface when they have finished.
*/
- (void) controllerData: (bycopy id) results forProcess: (int) pid;
@end

#endif
