/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef ADUN_BONDED
#define ADUN_BONDED

#include <math.h>
#include "Base/InterTable.h"
#include "AdunKernel/AdDataSources.h"
#include "AdunKernel/AdunEnvironment.h"
#include "AdunKernel/AdunSystemComponent.h"
#include "AdunKernel/AdunDefinitions.h"

/*!
\ingroup Inter
AdBondedTopology is an abstract class for holding bonded topology information. 
\todo Find a good way to deal with converting the parameters in the topology tables 
*/

@interface AdBondedTopology: AdSystemComponent
{
	NSDictionary* topologyDict;
} 
- (id) interactions;
@end

#endif
