#ifndef _ADDATASET_
#define _ADDATASET_

#include <Foundation/Foundation.h>
#include "AdunKernel/AdunModelObject.h"
#include "AdunKernel/AdunDataMatrix.h"

/**
Holds a collections of related data matrices along with information on how
they were generated.
*/

@interface AdDataSet: AdModelObject
{
	NSString* dataGeneratorID;
	NSMutableArray* dataMatrices;
}


- (id) initWithName: (NSString*) aString;
- (id) initWithName: (NSString*) name inputReferences: (NSDictionary*) aDict;
/**
Creates a new AdDataSet instance for data generated from the AdModelObjects or simulation trajectories with the
ids given by \e anArray by the plugin \e aBundle and names the data set \e aString.
*/
- (id) initWithName: (NSString*) aString 
	inputReferences: (NSDictionary*) aDict
	dataGenerator: (NSBundle*) aBundle;
- (id) initWithName: (NSString*) stringOne 
	inputReferences: (NSDictionary*) aDict
	dataGeneratorName: (NSString*) stringTwo
	dataGeneratorVersion: (NSString*) aNumber;
/**
Adds \e aDataMatrix to the data set
*/
- (void) addDataMatrix: (AdDataMatrix*) aDataMatrix;
/**
Removes the matrix \e aDataMatrix from the data set. Does nothing
if aDataMatrix is not part of the data set.
*/
- (void) removeDataMatrix: (AdDataMatrix*) aDataMatrix;
/**
Removes the data matrix with name \e aString from the dataSet. Does
nothing if no data matrix with name \e aString is present. If there
is more than one matrix with name \e aString the first
one found is removed.
*/
- (void) removeDataMatrixWithName: (NSString*) aString;
/**
Returns an array containing all the data matrices in the data set
*/
- (NSArray*) dataMatrices;
/**
Returns the data matrix with name \e aString from the dataSet. Does
nothing if no data matrix with name \e aString is present. If there
is more than one matrix with name \e aString it returns the first
one found.
*/
- (AdDataMatrix*) dataMatrixWithName: (NSString*) aString;
/**
Returns the id of the plugin that generated the data - usually \e pluginName_pluginVersion 
*/
- (NSString*) dataGeneratorID;
/**
Returns the name of the plugin that generated the data or unknown if none was supplied found.
*/
- (NSString*) dataGeneratorName;
/**
Returns the version number of the plugin that generated the data or "1.0" if none was supplied
*/
- (double) dataGeneratorVersion;
@end

#endif
