/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-06-23 11:06:55 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
#ifndef _ADDATASOURCE_
#define _ADDATASOURCE_

#include <math.h>	
#include <Foundation/Foundation.h>
#include "Base/InterTable.h"
#include "AdunKernel/AdDataSources.h"
#include "AdunKernel/AdUpdating.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunObject.h"
#include "AdunKernel/AdunMemoryManager.h"
#include "AdunKernel/RemoteProcessAccess.h"

/**
\ingroup Cinter
AdSystem data source created from a ULSystem object
*/

@interface AdDataSource: AdObject <AdSystemDataSource>
{
	@private
	BOOL memento;
	AdMatrix* coordinates;
	NSMutableDictionary* bondedInteractions;
	NSMutableDictionary* nonbondedInteractionTypes;
	NSArray* atomTypes;
	id nonbondedInteractions;
	id memoryManager;
	NSString* systemName;		//This is a preliminary ivar that describes the system and/or its use. 
					//The keywords have yet to be defined fully.
	NSString* type;
	NSString* currentCaptureMethod;
}

+ (id) dataSourceForULSystem: (id) ulsystem withEnvironment: (id) object; 
- (id) initWithULSystem: (id) ulSystem environment: (id) object observe: (BOOL) value;

@end

/**
Category for AdDataSource containing the implementations of the 
NSCoding and AdMemento protocols
*/

@interface AdDataSource (AdDataSourceCodingExtensions) <AdMemento, NSCoding>
@end

#endif

