/*
   Project: Adun

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/
/**\file**/
#ifndef _ADUNIOMANAGER_
#define _ADUNIOMANAGER_

#include <stdlib.h>
#include <malloc.h>
#include "Base/InterTable.h"
#include "AdunKernel/AdunDefinitions.h"
#include "AdunKernel/AdunObject.h"
#include "AdunKernel/AdunEnvironment.h"

/*!
\ingroup Inter
AdMemory manager provides memory allocation
functionality to the framework. 
*/

@interface AdMemoryManager: AdObject 
{
	struct mallinfo mem_struct;
	BOOL MEMORY_STATS;
}

/**
Returns the shared memory manager for the application. 
**/
+ (id) appMemoryManager;
/** Allocates an array of size \e size
\param size the size of the array in bytes **/
- (void*) allocateArrayOfSize: (int) size;
/** Frees an array allocated with allocateArrayOfSize: 
\param array A pointer to the first element of the array to be freed i.e. array[0]**/
- (void) freeArray: (void*)array;
/** frees an admatrix allocated with allocatematrixwithrows:withcolumns
\param matrix a pointer to the admatrix struct
*/
- (void) freeMatrix: (AdMatrix*) matrix; 
/** frees an Intmatrix allocated with allocateIntMatrixWithRows:withColumns
\param matrix a pointer to the admatrix struct
*/
- (void) freeIntMatrix: (IntMatrix*) matrix; 
/**Allocates an AdMatrix with the requseted dimensions
\param no_rows The number of rows in the matrix
\param no_columns The number of columns in the matrix
\return A pointer to a AdMatrix struct which contain a reference to the allocated memory area
*/
- (AdMatrix*) allocateMatrixWithRows: (int) no_rows withColumns: (int) no_columns;
/**Allocates an IntMatrix with the requseted dimensions
\param no_rows The number of rows in the matrix
\param no_columns The number of columns in the matrix
\return A pointer to an IntMatrix struct which contain a reference to the allocated memory area
*/
- (IntMatrix*) allocateIntMatrixWithRows: (int) no_rows withColumns: (int) no_columns;
/** Frees an InterTable allocated with allocateInterTableWithRows:withColumns
\param matrix A pointer to the InterTable struct
*/
- (void) freeInterTable: (InterTable*) matrix; 
/**Allocates an InterTable with the requseted dimensions
\param no_rows The number of rows in the matrix
\param no_columns The number of columns in the matrix
\return A pointer to a InterTable struct which contain a reference to the allocated memory area
*/
- (InterTable*) allocateInterTableWithRows: (int) no_rows withColumns: (int) no_columns;
@end

#endif
