/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-12 15:24:33 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULDATABASEINTERFACE_H_
#define _ULDATABASEINTERFACE_H_

#include <Foundation/Foundation.h>
#include <AdunKernel/AdunDataSet.h>
#include "ULFramework/ULIOManager.h"
#include "ULFramework/ULFileSystemDatabaseBackend.h"

/**
\ingroup mControl
*/

@interface ULDatabaseInterface : NSObject
{
	NSMutableDictionary* backends;	
	NSMutableArray* availableClients;
	ULFileSystemDatabaseBackend* fileSystemBackend;
	id backend;
	Class ULSQLDatabaseBackend;
}
+ (id) databaseInterface;
- (id) backendForClient: (NSString*) clientName;
- (id) createFileSystemStorageForSimulation: (id) object;
- (BOOL) objectInFileSystemDatabase: (id) object;
- (void) addObject: (id) object 
		toSchema: (NSString*) schema
		ofClient: (id) clientName;
- (void) addObjectToFileSystemDatabase: (id) object;
- (void) removeObjectOfClass: (id) className 
		withID: (NSString*) ident 
		fromSchema: (NSString*) schema
		ofClient: (id) clientName;
- (void) removeObjectsOfClass: (id) className 
		withIDs: (NSArray*) idents
		fromSchema: (NSString*) schema
		ofClient: (NSString*) clientName;
- (id) unarchiveObjectWithID: (NSString*) ident 
	ofClass: (NSString*) className 
	fromSchema: (NSString*) schema
	ofClient: (NSString*) clientName;
- (NSArray*) availableObjectsOfClass: (NSString*) className 
		inSchema: (NSString*) schema
		ofClient: (NSString*) clientName;
- (id) metadataForObjectWithID: (NSString*) ident 
	ofClass: (NSString*) className 
	inSchema: (NSString*) schema
	ofClient: (NSString*) clientName;
/**
The schema and clientName args are redundant here since they
are available through \e object
*/
- (void) updateMetadataForObject: (id) object 
		inSchema: (NSString*) schema
		ofClient: (NSString*) clientName;
- (void) updateOutputReferencesForObject: (id) object;		
- (id) outputReferencesForObjectWithID: (NSString*) ident 
	ofClass: (NSString*) className 
	inSchema: (NSString*) schema
	ofClient: (NSString*) clientName;
- (id) inputReferencesForObjectWithID: (NSString*) ident 
	ofClass: (NSString*) className 
	inSchema: (NSString*) schema
	ofClient: (NSString*) clientName;
- (void) removeOutputReferencesToObjectWithID: ident
		ofClass: (id) className
		inSchema: (NSString*) schema
		ofClient: (NSString*) clientName;
- (NSArray*) contentTypeInformationForSchema: (NSString*) schema
		ofClient: (NSString*) clientName;
- (NSArray*) availableClients;
- (NSArray*) schemaInformationForClient: (NSString*) clientName;
- (NSString*) userForClient: (NSString*) clientName;
- (NSString*) databaseForClient: (NSString*) clientName;
- (void) saveDatabase;
@end


#endif 

