/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-05-23 15:46:27 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#ifndef _ULIOMANAGER_H_
#define _ULIOMANAGER_H_

#include <Foundation/Foundation.h>
#include <ULFramework/ULDatabaseIndex.h>

/**
Singleton Class for handling input and output for the UserLand
\ingroup model
*/

@interface ULIOManager : NSObject
{
	NSFileManager* fileManager; 	//!< The NSFileManager instance for the process
	NSString* currentDir;		//!< Current Directory
	NSString* userHome;		//!< Current users home directory
	NSString* adunPath;		//!< Path to the .adun directory 
	NSString* kernelDir;		//!< Path to the kernel source directory
	NSString* applicationDir;	//!< Path to the user adun directory
	NSString* userPluginsDir;	//!< Path to the users plugin directory
	NSString* databaseDir;		//!< Path to the database directory
	NSString* controllerOutputDir; 	//!< Path to where controllers can write output
	NSProcessInfo* processInfo;	//!< Information on the current process environment
}

/**
Returns the ULIOManager instance for the process
*/

+ (id) appIOManager;
- (NSArray*) configurationPlugins;
- (NSString*) applicationDir;
- (NSString*) databaseDir;
/**
Returns the name of the directory where (non-data) controller
output is written. The output of a controller is contained in a
subdirectory of this directory
*/
- (NSString*) controllerOutputDir;
/**
Writes \e object to the specified file. If the object cannot be written this method
returns NO and \e error is set describing the reasons for failure. On success YES
is returned. Note \e object must respond to writeToFile:atomically:.
*/
- (BOOL) writeObject: (id) object toFile: (NSString*) filename error: (NSError**) error;
@end


@interface ULIOManager (ULTemporaryFileExtensions)

/**
Creates and returns the path to a unique temporary directory.
The directory is created with the default attributes. 
If the directory cant be created this method raises an NSInternalInconsistencyException
since being unable to create temp dirs is a critical error.
*/
- (NSString*) temporaryDirectoryWithPrefix: (NSString*) prefix;
@end

#endif // _ULIOMANAGER_H_

