/*
   Project: UL

   Copyright (C) 2005 Michael Johnston & Jordi Villa-Freixa

   Author: Michael Johnston

   Created: 2005-07-06 16:32:28 +0200 by michael johnston

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include "ULOptions.h"

@implementation ULOptions

- (id) init
{
	self = [super init];
	return self;
}

+ (ULOptions*) optionsWithContentsOfFile: (NSString*) path
{
	id obj;

	obj = [ULOptions new];
	[obj takeValue: [NSMutableDictionary dictionaryWithContentsOfFile: path]
		forKey: @"Options"];
	return obj;
}

- (id) Options
{
	return options;
}

- (void) setOptions: (NSMutableDictionary*) opt
{
	[options release];
	options = opt;
	[options retain];
}

- (void) dealloc
{
	[options release];
	[super dealloc];
}

/**************
NSCoding
*************/

- (void) encodeWithCoder: (NSCoder*) encoder
{
	[super encodeWithCoder: encoder];
	if([encoder allowsKeyedCoding])
		[encoder encodeObject: options forKey: @"Options"];
	else
		[encoder encodeObject: options];
}

- (id) initWithCoder: (NSCoder*) decoder
{
	self = [super initWithCoder: decoder];
	if([decoder allowsKeyedCoding])
		options = [[decoder decodeObjectForKey:@"Options"] retain];
	else
		options = [[decoder decodeObject] retain];
	

	if([generaldata objectForKey: @"Class"] == nil)
		[generaldata setObject: @"ULOptions" forKey: @"Class"];

	return self;
} 

@end
