# ----------------------------------------------------------
# AdvaS Advanced Search
# advanced search algorithms implemented as a python module
#
# Testing module
#
# (C) 2002 - 2005 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
# ----------------------------------------------------------

# updated 2005-01-28

import advas

print "AdvaS Advanced Search Integrity Check"

# basic string functions
print "\nTesting basic string functions ..."
# - split_line
#   split line of text into single words
line = "red green blue yellow magenta white orange green cyan black"
words = advas.split_line (line)
if (len(words) == 10):
	print "split_line() ok"
else:
	print "split_line() failed:"
	print "parameter:", line
	print "result:", words

# - cmp_strings
term1 = "red"
term2 = "blue"
term3 = "green"
cmp1 = advas.cmp_strings (term2, term2)
cmp2 = advas.cmp_strings (term1, term2)
cmp3 = advas.cmp_strings (term2, term3)
if ((cmp1 == 0) and (cmp2 == 1) and (cmp3 == -1)):
	print "cmp_strings() ok"
else:
	print "cmp_strings() failed:"
	print '%s, %s : %d' % (term2, term2, cmp1)
	print '%s, %s : %d' % (term1, term2, cmp2)
	print '%s, %s : %d' % (term2, term3, cmp3)

# - is_comment
comment1 = " # comment"
comment2 = "no comment #"
if (advas.is_comment(comment1) == 1) and (advas.is_comment(comment2) == 0):
	print "is_comment() ok"
else:
	print "is_comment() failed:"
	print comment1, advas.is_comment(comment1)
	print comment2, advas.is_comment(comment2)

# - kmp_search
text = "A string searching example helping you."
pattern = "ing"
positions = advas.kmp_search (text, pattern)
if positions == [5, 15, 31]:
	print "kmp_search() ok"
else:
	print "kmp_search() failed:"
	for i in positions:
		print text[i:i + len(pattern)], "at position ", i

# basic list functions
print "\nTesting basic list functions ..."
# - count_words
#   count the words and create a list word:frequency
list = advas.count_words (words)
if list["green"] == 2:
	print "count_words() ok"
else:
	print "count_words() failed:"
	print "parameter:", words
	key = list.keys()
	for item in key:
		print item + " : " + str(list[item])

# - merge_lists
list1 = {"red":1, "blue":2, "green":3} 
list2 = {"red":-1, "orange":1, "black": 4}
merge1 = advas.merge_lists(list1)
merge2 = advas.merge_lists(list1, list2)

if ((merge1 == list1) and (merge2 == {"red":0, "blue":2, "green":3, "orange":1, "black":4})):
	print "merge_lists() ok"
else:
	print "merge_lists() failed:"
	print list1
	print list2
	print merge1
	print merge2

# - merge_lists_idf
merge3 = advas.merge_lists_idf(list1)
merge4 = advas.merge_lists_idf(list1, list2)

if ((merge3 == {"red":1, "blue":1, "green":1}) and (merge4 == {"red":2, "blue":1, "green":1, "orange":1, "black":1})):
	print "merge_lists_idf() ok"
else:
	print "merge_lists_idf() failed:"
	print list1
	print list2
	print merge3
	print merge4

# - compact_list
list5 = {'red': 1, 'blue': 2, 'green': 3, 'Red': 4}
compact = advas.compact_list(list5)
if (compact == {"red":5, "blue":2, "green":3}):
	print "compact_list() ok"
else:
	print "compact_list() failed:"
	print list5
	print compact

# - remove_items
list1 = {"red":1, "blue":2, "green":3}
list2 = {"green":2}
updated = advas.remove_items (list1, list2)
if (updated == {"red":1, "blue":2}):
	print "remove_items() ok"
else:
	print "remove_items() failed"
	print list1
	print list2
	print updated

# - convert_dictionary_into_list
dict = {"red":1, "blue":2, "green":3}
list1 = advas.convert_dictionary_into_list(dict)
if (("blue" in list1) and ("green" in list1) and ("red" in list1)):
	print "convert_dictionary_into_list() ok"
else:
	print "convert_dictionary_into_list() failed"
	print dict
	print list1

# - convert_list_into_dictionary
list1 = ["red", "green", "blue"]
init = "1"
dict = advas.convert_list_into_dictionary(list1, init)
if ((dict["red"] == '1') and (dict["blue"] == '1') and (dict["green"] == '1')):
	print "convert_list_into_dictionary () ok"
else:
	print "convert_list_into_dictionary () failed"
	print list1
	print init
	print dict

# successor variety functions
print "\nTesting successor variety functions ..."
# - calc_succ_variety
list1 = ["garbage"]
flag = 1
csv = advas.calc_succ_variety(list1, flag)
if ((csv['a'] == 2) and (csv['b'] == 1) and (csv['r'] == 1) and (csv['g'] == 2)):
	print "calc_succ_variety() ok"
else:
	print "calc_succ_variety() failed"
	print list1
	print flag
	print csv

# descriptor functions
print "\nTesting descriptor functions ..."
# - calc_rsv
request = ["red", "green"]
document = ["red", "green", "orange"]
d = [1, 1, 0]
p = [0.5, 0.5, 0.2]
q = [0.5, 0.5, 0.1]
rsv = advas.calc_rsv (d, p, q)
if (rsv == 0):
	print "calc_rsv() ok"
else:
	print "calc_rsv() failed"
	print d
	print p
	print q
	print rsv

# - comp_descriptors
request = ["red", "green", "blue"]
desc = ["red", "blue", "green"]
v = advas.comp_descriptors (request, desc)
if (int(v) == 1):
	print "comp_descriptors() ok"
else:
	print "comp_descriptors() failed:"
	print request
	print desc
	print v

# phonetic algorithms
print "\nTesting phonetic algorithms ..."
# - phonetic_code
values = advas.phonetic_code ("Frank")
if (values["soundex"] == "F652"):
	print "soundex() ok"
else:
	print "soundex() failed"
	print "Frank: ", values["soundex"]

if (values["caverphone"] == "FRNK111111"):
	print "caverphone() ok"
else:
	print "caverphone() failed"
	print "Frank: ", values["caverphone"]

if (values["metaphone"] == "frnk"):
	print "metaphone() ok"
else:
	print "metaphone() failed"
	print "Frank: ", values["metaphone"]

if (values["nysiis"] == "Franc"):
	print "nysiis() ok"
else:
	print "nysiis() failed"
	print "Frank: ", values["nysiis"]

# synonym functions
print "\nTesting synonym functions ..."
# - synonym_of
# - is_synonym_of
print "[ ... skipped ... ]"

# category functions
print "\nTesting category functions ..."
print "[ ... skipped ... ]"

# ngram functions
print "\nTesting ngram functions ..."
# - get_ngrams
term = "abracadabra"
size = 6
ngrams = advas.get_ngrams (term, size)
if (("abraca" in ngrams) and ("bracad" in ngrams) and ("racada" in ngrams) and ("acadab" in ngrams) and ("cadabr" in ngrams) and ("adabra" in ngrams)):
	print "get_ngrams() ok"
else:
	print "get_ngrams() failed"
	print term
	print size
	print ngrams

# - comp_ngrams
term1 = "green"
term2 = "greek"
size = 2
v = advas.comp_ngrams (term1, term2, size)
if (int(v*100) == 75):
	print "comp_ngrams() ok"
else:
	print "comp_ngrams() failed"
	print term1
	print term2
	print size
	print v

# advanced functions
print "\nTesting advanced functions ... "
# - tf
text = "the long long way"
text_tf = advas.tf(text)
if (text_tf == {"the":1, "long":2, "way":1}):
	print "tf() ok"
else:
	print "tf() failed"
	print text
	print text_tf

# - tf_stop
text = "the even longer way"
stop_list = {"the":1}
text_tf_stop = advas.tf_stop(text, stop_list)
if (text_tf_stop == {"even":1, "longer":1, "way":1}):
	print "tf_stop() ok"
else:
	print "tf_stop() failed"
	print text
	print stop_list
	print text_tf_stop

# - idf
documents = 4
word_list = {"red":2, "green":4, "orange":3}
idf_value = advas.idf(documents, word_list)
if (idf_value["green"] == 0):
	print "idf() ok"
else:
	print "idf() failed"
	print documents
	print word_list
	print idf_value

# stemming functions
print "\nTesting stemming algoritms ..."
print "[ ... skipped ... ]"

print "\nDone."

