
# ----------------------------------------------------------
# advas
# advanced search algorithms implemented as a python module
#
# (C) 2002-05 Frank Hofmann, Chemnitz, Germany
# email fh@efho.de
#
# example for comparing phonetic algorithms
#
# ----------------------------------------------------------

# changed 2005-01-28

# import advas module
import advas
import re

phonetic_terms = (
		"schmidt", "schmid", "schmitt", "smith", "smythe", "schmied", 
		"mayer", "meier", "maier", "meyer",
		"schulz", "schulze", "schultz", "schultze",
		"phonology", "phonologist", "phonological", "phonograph", "phoneme", "phonemics"#,
		#"schifffahrt", "dammmeister"
		)
algorithms_list = (" ", "soundex", "metaphone", "nyiis", "caverphone")

for algorithm in algorithms_list:
	print "%15s" % algorithm,
# end for

print "\n" + "=" * 100

for term in phonetic_terms:
	print "%12s" % term, ": ", "%15s" % advas.soundex(term), "%15s" % advas.metaphone(term), "%15s" % advas.nysiis(term), "%15s" % advas.caverphone(term)

