/* Sendmail.h - Declarations for af's mail sending routines.
   Copyright (C) 1991 - 2002 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#define SENDMAILID	"$Id: sendmail.h,v 2.3 2002/08/21 23:54:48 malc Exp $"

/****************************************************************************/
/* The structure used to hold header information */

typedef struct header {
	char *name, *text, *saved;	/* Header name and (saved) text */
	unsigned edit : 1;		/* Can we edit this header? */
	unsigned show : 1;		/* Show this header in edits? */
	unsigned reqd : 1;		/* Is this header required? */
	unsigned uniq : 1;		/* Must header appear only once? */
	unsigned found : 1;		/* Did we find this header? */
	char *(*chk_func)();		/* Function to check header */
	struct header *next;		/* Pointer to next header */
} HEADER;

/****************************************************************************/
/* The structure used to hold a composition */

typedef struct {
	MESSAGE *message;		/* The message we're composing */
	HEADER *headers;		/* The message's headers */
	TEXTLINE *body;			/* Start of the message body */
	char *sigfile;			/* Signature file to use */
	char *encoded;			/* How is the body encoded? */
	unsigned updated : 1;		/* Have we updated the composition? */
	unsigned body_part : 1;		/* Is this a body part? */
	unsigned multipart : 1;		/* Are we sending a multipart? */
	unsigned mime : 1;		/* Are we sending a MIME message? */
	unsigned reply : 1;		/* Are we replying to a message? */
	unsigned forward : 1;		/* Are we forwarding a message? */
	unsigned bounce : 1;		/* Are we bouncing a message? */
	unsigned file : 1;		/* Are we sending a file? */
	unsigned attachments : 1;	/* Are we sending attachments? */
	unsigned silent : 1;		/* Are we sending silently? */
	unsigned editing : 1;		/* Are we editing a message? */
	unsigned copy : 1;		/* Copy the original message? */
} COMPOSITION;

/****************************************************************************/
/* The flags which control sending mail */

#define SM_SEND		0x0000
#define SM_REPLY	0x0001
#define SM_FORWARD	0x0002
#define	SM_BOUNCE	0x0004
#define SM_ATTACH	0x0008
#define SM_EDIT		0x0010
#define SM_MPART	0x0100
#define SM_MIME		0x0200
#define SM_ALL_HEADERS	0x0400
#define SM_SILENT	0x0800
#define SM_BODY_PART	0x1000

/****************************************************************************/
/* The flags which control saving a composition */

#define CS_SAVE		0x00
#define CS_MBOX		0x01
#define CS_BODY		0x02
#define CS_EDIT		0x04

/****************************************************************************/
/* The possible options after composing a message */

#define SC_MAIL_OPTS	"acefls"
#define MAIL_OPTS	"aefls"

/* And definitions of what each option is */

#define SEND_MESSAGE	's'
#define EDIT_MESSAGE	'e'
#define ATTACHMENTS	'a'
#define CHECK_SPELLING	'c'
#define LIST_MESSAGE	'l'
#define FORGET_MESSAGE	'f'

/****************************************************************************/
/* The width of a header or body line */

#define FOLD_WIDTH	72
#define LINESIZE	80

/****************************************************************************/
/* The maximum length of a message ID excluding host name */

#define BASEIDLEN	23

/****************************************************************************/
/* The base text we use for In-Reply-To: headers */

#define INREPLY_TEXT1	"Mail from "
#define INREPLY_TEXT2	" on "

/****************************************************************************/
/* The string used to quote unwanted 'From ' lines */

#define FROM_QUOTE	">"

/****************************************************************************/
/* The base boundary string for af */

#define BOUNDARY_TEXT	"af-boundary-"

/****************************************************************************/
/* Is character c a newline character? */

#define IS_NEWLINE(c)	((c) == '\n' || (c) == '\r')

/* Is character c RFC 822 linear-white-space? */

#define IS_LWSP(c)	((c) == ' ' || (c) == '\t')

/****************************************************************************/
