/* 
   Affix - Bluetooth Protocol Stack for Linux
   Copyright (C) 2001 Nokia Corporation
   Original Author: Dmitry Kasatkin <dmitry.kasatkin@nokia.com>

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
   */

/* 
   $Id: packet.h,v 1.1 2003/03/02 15:34:14 kds Exp $

   TCI - Test Control Interface definitions

*/

#ifndef _AFFIX_TCI_H
#define _AFFIX_TCI_H


#define TCI_DATA_PKT			HCI_ACL
#define TCI_CMD_PKT			HCI_COMMAND
#define TCI_EVENT_PKT			HCI_EVENT

#define TCI_DATA_HDR_LEN		4
#define TCI_CMD_HDR_LEN			3
#define TCI_EVENT_HDR_LEN		2

/* TCI L2CAP events */
#define TCI_L2CAP_EVENT			HCI_E_TCI
#define TCI_L2CAP_CMP_EVENT		HCI_E_COMMAND_COMPLETE

/* sub events */
#define TCI_L2CAP_CONNECT_IND		0x01
#define TCI_L2CAP_CONFIG_IND		0x02
#define TCI_L2CAP_DISCONNECT_IND	0x03
#define TCI_L2CAP_QOSVIOLATION_IND	0x04
#define TCI_L2CAP_TIMEOUT_IND		0x05


/* TCI L2CAP commands */
#define TCI_L2CAP_CONNECT_REQ		0xF801
#define TCI_L2CAP_DISCONNECT_REQ	0xF802
#define TCI_L2CAP_CONFIG_REQ		0xF803
#define TCI_L2CAP_DISABLE_CLT		0xF804
#define TCI_L2CAP_ENABLE_CLT		0xF805
#define TCI_L2CAP_GROUP_CREATE		0xF806
#define TCI_L2CAP_GROUP_CLOSE		0xF807
#define TCI_L2CAP_GROUP_ADD_MEMBER	0xF808
#define TCI_L2CAP_GROUP_REMOVE_MEMBER	0xF809
#define TCI_L2CAP_GROUP_MEMBERSHIP	0xF80A
#define TCI_L2CAP_WRITE_DATA		0xF80B
#define TCI_L2CAP_READ_DATA		0xF80C
#define TCI_L2CAP_PING			0xF80D
#define TCI_L2CAP_GET_INFO		0xF80E
#define TCI_L2CAP_CONNECT_RSP		0xF811
#define TCI_L2CAP_DISCONNECT_RSP	0xF812
#define TCI_L2CAP_CONFIG_RSP		0xF813

#define TCI_L2CAP_CFGCFM_SUCCESS	0x0000
#define TCI_L2CAP_CFGCFM_CID		0x0001
#define TCI_L2CAP_CFGCFM_PARAMETERS	0x0002
#define TCI_L2CAP_CFGCFM_MTU		0x0003
#define TCI_L2CAP_CFGCFM_OPTIONS	0x0004

#define TCI_L2CAP_CFGRSP_SUCCESS	0x0000
#define TCI_L2CAP_CFGRSP_PARAMETERS	0x0001
#define TCI_L2CAP_CFGRSP_REJECT		0x0002
#define TCI_L2CAP_CFGRSP_CID		0x0003
#define TCI_L2CAP_CFGRSP_OPTIONS	0x0004

#ifdef __KERNEL__

#define TCI_EVENT_LEN(event)	(sizeof(event) - TCI_EVENT_HDR_LEN)
#define TCI_CMD_LEN(cmd)	(sizeof(cmd) - TCI_CMD_HDR_LEN)

typedef struct {
	__u16	opcode;
	__u8	length;
	__u8	data[0];
}__PACK__ tci_cmd_hdr_t;

typedef struct {
	__u8	event;
	__u8	length;
	__u8	subevent;
	__u8	data[0];
}__PACK__ tci_event_hdr_t;

typedef struct {
	__u8	event;
	__u8	length;	
	__u8	num;
	__u16	opcode;
	__u8	data[0];
} __PACK__ tci_cmp_hdr_t;
	
typedef struct {
	__u16	handle;
	__u16	length;
	__u8	data[0];
}__PACK__ tci_data_hdr_t;

#else /* __USER__ */

#define TCI_EVENT_LEN(event)	(sizeof(event) - TCI_EVENT_HDR_LEN - 1)
#define TCI_CMD_LEN(cmd)	(sizeof(cmd) - TCI_CMD_HDR_LEN - 1)

typedef struct {
	__u8	type;
	__u16	opcode;
	__u8	length;
	__u8	data[0];
}__PACK__ tci_cmd_hdr_t;

typedef struct {
	__u8	type;
	__u8	event;
	__u8	length;
	__u8	subevent;
	__u8	data[0];
}__PACK__ tci_event_hdr_t;

typedef struct {
	__u8	type;
	__u8	event;
	__u8	length;	
	__u8	num;
	__u16	opcode;
	__u8	data[0];
} __PACK__ tci_cmp_hdr_t;
	
typedef struct {
	__u8	type;
	__u16	handle;
	__u16	length;
	__u8	data[0];
}__PACK__ tci_data_hdr_t;


#endif

/* commands */

struct tci_connect_req {
	tci_cmd_hdr_t	hdr;
	__u16		psm;
	BD_ADDR		bda;
} __PACK__;

struct tci_disconnect_req {
	tci_cmd_hdr_t	hdr;
	__u16		cid;
} __PACK__;

struct tci_config_req {
	tci_cmd_hdr_t	hdr;
	__u16		cid;
	__u16		mtu;
	l2cap_qos_t	flow;
	__u16		flush_to;
	__u16		link_to;
} __PACK__;

struct tci_connect_rsp {
	tci_cmd_hdr_t	hdr;
	BD_ADDR		bda;
	__u8		id;
	__u16		lcid;
	__u16		result;
	__u16		status;
} __PACK__;

struct tci_config_rsp {
	tci_cmd_hdr_t	hdr;
	__u16		cid;
	__u16		mtu;
	l2cap_qos_t	flow;
} __PACK__;

struct tci_write_data {
	tci_cmd_hdr_t	hdr;
	__u16		cid;
	__u16		length;
} __PACK__;

struct tci_read_data {
	tci_cmd_hdr_t	hdr;
	__u16		cid;
	__u16		length;
} __PACK__;

struct tci_ping {
	tci_cmd_hdr_t	hdr;
	BD_ADDR		bda;
	__u16		length;
	__u8		data[0];
} __PACK__;

struct tci_getinfo {
	tci_cmd_hdr_t	hdr;
	BD_ADDR		bda;
	__u16		type;
} __PACK__;

/* events */

struct tci_connect_ind {
	tci_event_hdr_t	hdr;
	BD_ADDR		bda;
	__u16		cid;
	__u16		psm;
	__u8		id;
} __PACK__;

struct tci_connect_cfm {
	tci_cmp_hdr_t	hdr;
	__u16		lcid;
	__u16		result;
	__u16		status;
} __PACK__;

struct tci_result_ind {
	tci_cmp_hdr_t	hdr;
	__u16		result;
} __PACK__;

struct tci_config_ind {
	tci_event_hdr_t	hdr;
	__u16		cid;
	__u16		mtu;
	l2cap_qos_t	flow;
	__u16		flush_to;
} __PACK__;

struct tci_config_cfm {
	tci_cmp_hdr_t	hdr;
	__u16		result;
	__u16		mtu;
	l2cap_qos_t	flow;
	__u16		flush_to;
} __PACK__;

struct tci_disconnect_ind {
	tci_event_hdr_t	hdr;
	__u16		cid;
} __PACK__;

struct tci_qosviolation_ind {
	tci_event_hdr_t	hdr;
	BD_ADDR		bda;
} __PACK__;

struct tci_write_cfm {
	tci_cmp_hdr_t	hdr;
	__u16		size;
	__u16		result;
} __PACK__;

struct tci_ping_cfm {
	tci_cmp_hdr_t	hdr;
	__u16		result;
	__u16		size;
	__u8		data[0];
} __PACK__;



#endif
