/* 
   Affix - Bluetooth Protocol Stack for Linux
   Copyright (C) 2001 Nokia Corporation
   Original Author: Dmitry Kasatkin <dmitry.kasatkin@nokia.com>

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* 
   $Id: btctl.h,v 1.25 2003/10/06 10:51:24 kds Exp $

   Header file for the BT server user space daemon 

   Fixes:
   		Dmitry Kasatkin <dmitry.kasatkin@nokia.com>
*/		

#ifndef BTCTL_H
#define BTCTL_H

#if defined(CONFIG_AFFIX_SDP)
#include <affix/sdp.h>
#include <affix/sdpclt.h>
#endif

extern char		**argv;
extern int		argc;
extern int		argind;
extern char		btdev[IFNAMSIZ];
//extern int		linkmode;
extern int		ftpmode;
extern int		uart_rate;
extern char		*uart_map;

extern btdev_list	*devcache;
#define get_bda(bda, buf)	btdev_get_bda(devcache, bda, buf)

struct btctl_command {
	char	*name;
	int	(*func)(struct btctl_command *cmd);
	int	cmd;
	char	*arg;
	char	*msg;	/* extra info message */
};

/* btctl.c */
void usage(void);
void print_help(struct btctl_command *cmd);
void print_usage(struct btctl_command *cmd);
int cmd_help(struct btctl_command *bcmd);
int cmd_prompt(struct btctl_command *bcmd);

/* btctl-sdp.c */
int cmd_browse(struct btctl_command *bcmd);
int cmd_search(struct btctl_command *bcmd);

/* btctl-obex.c */
int cmd_open(struct btctl_command *bcmd);
int cmd_close(struct btctl_command *bcmd);
int cmd_ls(struct btctl_command *bcmd);
int cmd_get(struct btctl_command *bcmd);
int cmd_put(struct btctl_command *bcmd);
int cmd_push(struct btctl_command *bcmd);
int cmd_rm(struct btctl_command *bcmd);
int cmd_cd(struct btctl_command *bcmd);
int cmd_mkdir(struct btctl_command *bcmd);

/* btctl-dev.c */
#define CMD_INITDEV	0x00
#define CMD_UPDEV	0x01
#define CMD_DOWNDEV	0x02
int cmd_initdev(struct btctl_command *bcmd);
int cmd_capture(struct btctl_command *bcmd);

#define CMD_INIT_UART	0x00
#define CMD_OPEN_UART	0x01
#define CMD_CLOSE_UART	0x02
int cmd_uart(struct btctl_command *bcmd);

/* btctl-audio.c */
int cmd_audio(struct btctl_command *bcmd);
int cmd_play(struct btctl_command *bcmd);
int cmd_record(struct btctl_command *bcmd);
int cmd_addsco(struct btctl_command *bcmd);

/* PAN */
#define CMD_PAN_INIT	0
#define CMD_PAN_STOP	1
int cmd_pan_init(struct btctl_command *bcmd);
int cmd_pan_discovery(struct btctl_command *cmd);
int cmd_pan_connect(struct btctl_command *cmd);
int cmd_pan_disconnect(struct btctl_command *cmd);
int cmd_panctl(struct btctl_command *bcmd);



#endif	/*	BTCTL_H */

