#include "CalendarUser.h"
#include "CalendarEvent.h"

@implementation CalendarUser

+ (CalendarUser *) calendarUserWithCalendarDomain:(CalendarDomain *)domain
										 userName:(NSString *)userName
										 password:(NSString *)password
										 timeZone:(NSTimeZone *)timeZone
										 infoDict:(NSDictionary *)info
{
	return AUTORELEASE([[self alloc] initWithCalendarDomain:domain
												   userName:userName
												   password:password
												   timeZone:timeZone
												   infoDict:info]);

}

+ (void) resetCurrentCalendarUser
{
	[[[NSThread currentThread] threadDictionary] removeObjectForKey:@"CurrentCalendarUser"];
}

- (void) setCurrentCalendarUser
{
	[[[NSThread currentThread] threadDictionary] setObject:self forKey:@"CurrentCalendarUser"];
}

+ (id) currentCalendarUser
{
	return [[[NSThread currentThread] threadDictionary] objectForKey:@"CurrentCalendarUser"];
}

- (id) initWithCalendarDomain:(CalendarDomain *)domain
					 userName:(NSString *)userName
					 password:(NSString *)password
					 timeZone:(NSTimeZone *)timeZone
					 infoDict:(NSDictionary *)info
{
	AUTORELEASE(self);

	if (domain == nil)
	{
		return nil;
	}

	ASSIGN(_name, userName);
	ASSIGN(_password, password);

	__domain = domain;

	self = [domain authenticateCalendarUser:self];

	if (timeZone != nil)
	{
		ASSIGN(_timeZone, timeZone);
	}

	if (info != nil)
	{
		ASSIGN(_infoDict, info);
	}

	return RETAIN(self);
}

- (void) dealloc
{

	NSLog(@"dealloc user '%@'",self);
	RELEASE(_name);
	RELEASE(_password);
	RELEASE(_timeZone);
	RELEASE(_infoDict);

	[super dealloc];
}

- (NSString *)name
{
	return _name;
}

- (NSString *) password
{
	return _password;
}

- (NSDictionary *) infoDict
{
	return _infoDict;
}

- (NSTimeZone *)timeZone
{
	return _timeZone;
}

- (CalendarDomain *) calendarDomain;
{
	return __domain;
}

#if 0
- (BOOL) canPerformSelector:(SEL)aSel
				   onObject:(id <CalendarPrimitive>)object
{
	if (self == [__domain owner])
	{
		return YES;
	}

	/* more */

	return NO;
}
#endif


/** actions **/

/*
- (CalendarUser *) owner
{
	return self;
}

- (BOOL) canModifyCalendarOwner:(id <CalendarOwner>)obj
{
	[__domain calendarUser:self
	canModifyCalendarOwner:obj];
}

- (BOOL) canAppendCalendarOwner:(id <CalendarOwner>)obj
{
	[__domain calendarUser:self
	canAppendCalendarOwner:obj];
}

- (BOOL) canReadCalendarOwner:(id <CalendarOwner>)obj
{
	[__domain calendarUser:self
	  canReadCalendarOwner:obj];
}

+ (CalendarUser *) calendarUserWithName:(NSString *)userName
							   password:(NSString *)password
							   timeZone:(NSTimeZone *)timeZone
						 calendarDomain:(CalendarDomain *)domain
							   userInfo:(NSDictionary *)info
{
	return AUTORELEASE([[self alloc] initWithName:userName
										 password:password
										 timeZone:timeZone
								   calendarDomain:domain
										 userInfo:info]);
}

- (id) initWithName:(NSString *)name
		   password:(NSString *)password
		   timeZone:(NSTimeZone *)timeZone
	 calendarDomain:(CalendarDomain *)domain
		   userInfo:(NSDictionary *)info
{

	if ([domain containsCalendarUserWithName:name])
	{
		id oldUser;

		oldUser = [domain calendarUserWithName:name];

		if (oldUser != nil)
		{
			if (password != nil)
			{
				[oldUser setPassword:password];
			}
			if (info != nil)
			{
				[oldUser setUserInfo:info];
			}
			if (timeZone)
			{
				[oldUser setTimeZone:timeZone];
			}

			AUTORELEASE(self);
			return oldUser;
		}
	}

	__domain = domain;

	_eventDict = [[NSMutableDictionary alloc] init];
	_eventTrashDict = [[NSMutableDictionary alloc] init];
	_groupDict = [[NSMutableDictionary alloc] init];

	ASSIGN(_name, name);
	ASSIGN(_password, password);

	if (info == nil)
	{
		info = [NSDictionary dictionary];
	}
	ASSIGN(_userInfo, info);

	if (timeZone == nil)
	{
		timeZone = [[NSTimeZone alloc] init];
	}
	ASSIGN(_timeZone, timeZone);

	[domain setCalendarUser:self];

	AUTORELEASE(self);
	return RETAIN([domain calendarUserWithName:name]);
}


- (NSString *)description
{
	return [[NSArray arrayWithObjects:_name, __domain, _timeZone, nil] description];
}

- (CalendarEvent *) setCalendarEvent:(CalendarEvent *)event
{
	CalendarEvent *old;

	if ([event domain] != __domain)
	{
		event = [CalendarEvent calendarEventWithName:[event name]
										calendarUser:self
									   calendarGroup:[self calendarGroupWithName:[[event group] name]]
										   startDate:[event startDate]
											stopDate:[event stopDate]
									   summaryString:[event summaryString]];
	}

	old = [_eventDict objectForKey:[event name]];

	if (old == nil)
	{
		[_eventDict setObject:event forKey:[event name]];
		old = event;
	}
	else
	{
		[old setSummaryString:[event summaryString]];
		[old setStartDate:[event startDate]];
		[old setStopDate:[event stopDate]];
	}

	return old;
}

- (void) setTimeZone:(NSTimeZone *)timeZone
{
	ASSIGN(_timeZone, timeZone);
}

- (void) setPassword:(NSString *)newPassword
{
	ASSIGN(_password, newPassword);
}

- (void) setUserInfo:(NSDictionary *)info
{
	ASSIGN(_userInfo, info);
}

- (CalendarGroup *) calendarGroupWithName:(NSString *)name
{
	CalendarGroup *group;

	group = [_groupDict objectForKey:name];

	if (group == nil)
	{
		group = [CalendarGroup calendarGroupWithName:name
											   owner:self
									  calendarDomain:__domain];
		[_groupDict setObject:group forKey:name];
	}
	return group;
}

- (void) removeCalendarGroupWithName:(NSString *)name
{
	if ([_groupDict count] == 1)
	{
		return;
	}
	[_groupDict removeObjectForKey:name];
}

- (NSArray *) calendarGroups
{
	return [_groupDict allValues];
}

- (NSArray *) calendarEvents
{
	return [_eventDict allValues];
}

- (CalendarEvent *) calendarEventWithName:(NSString *)name
{
	return [_eventDict objectForKey:name];
}

*/
@end

@interface MyString:NSObject
@end


@implementation CalendarUserManager

- (id) initWithCalendarUser:(CalendarUser *)user
{
	ASSIGN(_user, user);
	return self;
}

- (void) dealloc
{
	RELEASE(_user);
	[super dealloc];
}

static NSMutableString *testStr = nil;
- (NSString *) name
{
	ASSIGN(testStr,[NSMutableString stringWithString:[_user name]]);
	return testStr;
}

- (NSString *)chk
{
	return testStr;
}


/*
- (NSDictionary *) userInfo
{
	return AUTORELEASE([[_user userInfo] mutableCopy]);
}

- (NSTimeZone *)timeZone
{
	if (_manager == _user || [_manager isRoot])
	{
		return AUTORELEASE([[_user timeZone] copy]);
	}
}
*/

/*
- (NSString *) password
{
	if (_manager == _user || [_manager isRoot])
	{
		if ([_user password] != nil)
		{
			return [NSString stringWithString:[_user password]];
		}
	}
	return nil;
}

- (BOOL) setTimeZone:(NSTimeZone *)timeZone
{
	if (_manager == _user || [_manager isRoot])
	{
		[_user setTimeZone:AUTORELEASE([[NSTimeZone alloc] initWithName:[timeZone name]])];
		return YES;
	}
	return NO;
}

- (BOOL) setPassword:(NSString *)newPassword
{
	if (_manager == _user || [_manager isRoot])
	{
		[_user setPassword:[NSString stringWithString:newPassword]];
		return YES;
	}
	return NO;
}

- (BOOL) setUserInfo:(NSDictionary *)info
{
	if (_manager == _user || [_manager isRoot])
	{
		[_user setUserInfo:[NSDictionary dictionaryWithDictionary:info]];
		return YES;
	}
	return NO;
}

- (CalendarGroup *) calendarGroupWithName:(NSString *)name
{
	if (_manager == _user || [_manager isRoot])
	{
		return AUTORELEASE([[CalendarGroupManager alloc]
				initWithCalendarGroup:[_user calendarGroupWithName:name]
				 manageByCalendarUser:_user]);
	}
	return nil;
}

- (void) removeCalendarGroupWithName:(NSString *)name
{
	if (_manager == _user || [_manager isRoot])
	{
		return [_user removeCalendarGroupWithName:name];
	}
}

- (NSArray *) calendarGroups
{
	if (_manager == _user || [_manager isRoot])
	{
		NSMutableArray *array;
		array = [NSMutableArray array];
		NSEnumerator *en;
		id obj;
		en = [[_user calendarGroups] objectEnumerator];
		while (obj = [en nextObject])
		{
			[array addObject:AUTORELEASE([[CalendarGroupManager alloc]
						initWithCalendarGroup:obj
						 manageByCalendarUser:_manager])];
		}

		return array;
	}
	return nil;
}

- (NSArray *) calendarEvents
{
	if (_manager == _user || [_manager isRoot])
	{
		NSMutableArray *array;
		array = [NSMutableArray array];
		NSEnumerator *en;
		id obj;
		en = [[_user calendarEvents] objectEnumerator];
		while (obj = [en nextObject])
		{
			[array addObject:AUTORELEASE([[CalendarEventManager alloc]
						initWithCalendarEvent:obj
						 manageByCalendarUser:_manager])];
		}

		return array;
	}
	return nil;
}
*/

@end
