#ifndef CalendarView_h
#define CalendarView_h

#include <Foundation/NSCalendarDate.h>
#include <AppKit/AppKit.h>

@protocol CalendarViewsController
@end

@protocol CalendarCell
- (int) renderModeOfCell:(id)cell;
- (BOOL) getRow:(int *)row
		 column:(int *)col
		 ofCell:(NSCell *)cell;
@end


@interface CalendarView:NSView <CalendarCell>
{
	NSCalendarDate *_date;
	NSCalendarDate *_viewDate;
	NSCalendarDate *_selectStart;
	NSCalendarDate *_selectStop;

	NSMatrix *_matrix;
	NSPopUpButton *_monthPop;
	NSPopUpButton *_yearPop;
	NSButton *_lButton;
	NSButton *_rButton;
	NSButton *_tdButton;

	id _delegate;
}
- (void) setCalendarDate:(NSCalendarDate *)date;
- (void) viewCalendarDate:(NSCalendarDate *)date;
- (NSCalendarDate *) date;
@end

#endif
