#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test if-elif-else flow constructs.
#
# $Id: control_flow.py 5987 2003-01-24 11:34:31Z andrewm $

import unittest
import albatross
import albatross_test

class IfThenElifElseCase(albatross_test.AlbatrossTestCase):
    template_dir = "control_flow"

    def html_test(self, template, value, expect):
        self.ctx.locals.x = value
        albatross_test.AlbatrossTestCase.html_test(self, template, expect)

    def check_if(self):
        self.html_test("if-elif-else.html", 0, "zero\n")

    def check_elif(self):
        self.html_test("if-elif-else.html", 1, "positive\n")

    def check_else(self):
        self.html_test("if-elif-else.html", -1, "negative\n")

    def check_unclosed(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "if-elif-fail.html", 0, "(none)")


class ControlFlowSuite(unittest.TestSuite):
    test_list = (
        "check_if",
        "check_elif",
        "check_else",
        "check_unclosed"
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(IfThenElifElseCase, self.test_list))

def suite():
    return ControlFlowSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
