#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test iterator constructs.
#
# $Id: iterator.py 5987 2003-01-24 11:34:31Z andrewm $

import unittest
import albatross
import albatross_test

class IteratorCase(albatross_test.AlbatrossTestCase):
    template_dir = "iterator"

    def check_iterator(self):
        self.html_test("iterator.html", "01234")

    def check_nested(self):
        self.html_test("nested.html", "000102101112")

    def check_unclosed(self):
        self.assertRaises(albatross.ApplicationError, self.html_test, "unclosed.html", "(none)")

    def check_colsdown(self):
        self.html_test("down.html", "+035+146+2+")

    def check_colsacross(self):
        self.html_test("across.html", "+012+345+6+")

class IteratorSuite(unittest.TestSuite):
    test_list = (
        "check_iterator",
        "check_nested",
        "check_unclosed",
        "check_colsdown",
        "check_colsacross"
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(IteratorCase, self.test_list))

def suite():
    return IteratorSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
