<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     version="1.1">

<xsl:output method="xml" indent="yes"/>
 
<!-- ################################################# -->
<!-- ### This XSLT Stylesheet converts Album Shaper albums### -->
<!-- ### from the 1.0 XML format to the 1.1 XML format        ### -->
<!-- ################################################# -->
<xsl:template match="album" mode="update1.0">
<album version="1.1">
  <name><xsl:value-of select="name"/></name>
  <description><xsl:value-of select="description"/></description>
  <author><xsl:value-of select="author"/></author>
  <created><xsl:value-of select="concat(modified/year, ' ', modified/month, ' ', modified/day)"/></created>
  <modified><xsl:value-of select="concat(modified/year, ' ', modified/month, ' ', modified/day)"/></modified>
  <theme>Classic</theme>
  <thumbnailDimensions>200 150</thumbnailDimensions>
  <slideshowDimensions>600 400</slideshowDimensions>
  <xsl:for-each select="subalbum">
  <subalbum>
    <name><xsl:value-of select="name"/></name>
    <description><xsl:value-of select="description"/></description>
    <xsl:for-each select="photo">
    <photo>
      <description><xsl:value-of select="description"/></description>
      <image>
        <md5><xsl:value-of select="imageMD5"/></md5>
      </image>
      <slideshow>
        <md5><xsl:value-of select="slideMD5"/></md5>
      </slideshow>
      <thumb>
        <md5><xsl:value-of select="thumbMD5"/></md5>
      </thumb>
    </photo>
    </xsl:for-each>
  </subalbum>    
  </xsl:for-each>
</album>
</xsl:template>
<!-- ####################################### -->

</xsl:stylesheet>
