//==============================================
//  copyright: (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef BACKEND_RECENTALBUMS_H
#define BACKEND_RECENTALBUMS_H

#include <qstringlist.h>

//--------------------
//forward declarations
//--------------------

//=====================================
/*! \brief This class maintains and handles saving and loading a list of recently viewed albums.
 *
 */
//=====================================

class RecentAlbums
{
//------------------------------------------------------
public:
  //constructs a recent albums object
  RecentAlbums();
  
  //clears listing of recent albums
  void clearList();

  //returns the number of entries in the listing
  int numEntries();
  
  //retunrs the max number of entries the listing will support
  int getMaxItems();
  
  //obtains entry from index
  void getEntry ( int index, QString& name, 
                  QString& location, QString& photoCount );

  //inserts an album to the list, removes prior refferences if they 
  //exists. if too many items are in list last item is removed.
  void insertEntry ( QString name, 
                     QString location, 
                     QString photos = "-1",
                     bool insertAtBack = true );
  //------------------------------------------------------
private:
  ///lists of album names and locations
  QStringList albumNames;
  QStringList albumLocations;
  QStringList albumPhotoCounts;
  
  ///max allowable items in list
  uint maxItems;
//------------------------------------------------------
};

#endif //BACKEND_RECENTALBUMS_H
