//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qiconview.h>

//Projectwide includes
#include "groupsWidget.h"

//==============================================
GroupsWidget::GroupsWidget( QWidget* parent,
                            const char* name ) : QIconView( parent, name)
{
  setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Minimum);
}
//==============================================
void GroupsWidget::contentsMousePressEvent ( QMouseEvent * e )
{
  //ignore all clicks other than left-clicks
  if( e->button() != Qt::LeftButton ) return;
  
  QIconView::contentsMousePressEvent( e );
}
//==============================================
void GroupsWidget::keyPressEvent( QKeyEvent* e )
{
  //change key left/right presses to up/down events
  int key = e->key();
  if( key == Key_Left) key = Key_Up;
  if( key == Key_Right) key = Key_Down;

  QIconView::keyPressEvent(
    new QKeyEvent(QEvent::KeyPress,
              key,
              e->ascii(),
              e->state(),
              e->text(),
              e->isAutoRepeat(),
              e->count() ) );
}
//==============================================
QSize GroupsWidget::sizeHint() const
{
  QSize s = QIconView::sizeHint();

  //find max item width
  s.setWidth(0);
  QIconViewItem *item;
  for( item = firstItem(); item != NULL; item = item->nextItem() )
  {
    if(item->width() + 2 > s.width() )
      s.setWidth( item->width() );
  }
  s.setWidth( s.width() + 2*spacing() );
  return s;
}
//==============================================
void GroupsWidget::setTextWidth(int val)
{ textWidth = val; }
//==============================================
int GroupsWidget::getTextWidth()
{ return textWidth; }
//==============================================


