//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide include
#include <qstring.h>

//Projectwide includes
#include "miscSettings.h"
#include "configuration.h"

//==============================================
void MiscSettings::setDefaults(Configuration* config)
{
  //true first time program is run, ensures "first run"
  //dialog is only brought up once and never again
  config->setBool( "misc", "firstRun", true );
  
  //warn users they are running a CVS build if they are
  config->setBool( "misc", "cvsWarn", true );  

  //DPI below which users will be warned during cropping
  config->setInt( "misc", "minDPI", 250 );
}
//==============================================
