//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "enhancing.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Enhancing::filename()
{
  return QString("%1/enhancing.html").arg(TEMP_DIR);
}
//==============================================
void Enhancing::generateHTML(QTextStream::Encoding type, QString charSet)
{
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Fix it Fast") << "</font></td>\n";
    stream << "</tr></table>\n";
    stream << "<font face='Arial, sans-serif'>\n";
    
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Enhancing your Photos:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper allows you to quickly enhance your photos. Enhancing controls are clustered at the bottom center of the editing interface.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/enhanceControls.png'>\n";
    stream << "</td></tr></table>\n";
      
    stream << "</td></tr><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Color Correction:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/colorCorrection.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("When taking photos under poor light without a flash, or simply when odd lighting is present, your photos can take on strange tints that can be quite irritable. Clicking the <font color='red'>Color</font> button can often fix such problems.") << "\n";
    stream << "</td></tr></table>\n";
      
    stream << "</td></tr><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Contrast Correction:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Sometimes your photos appear muddy or have a haze over them, obscuring details. Whether the water was muddy, your lense was dirty, or mist was in the air, Album Shaper will try to fix these problems if you click the <font color='red'>Contrast</font> button.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/contrastCorrection.png'>\n";
    stream << "</td></tr></table>\n";
      
    stream << "</td></tr><tr><td>\n";
      
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Red Eye Removal:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/redEyeRemoval.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Compact digital camera designs that use an integrated flash often capture red-eye artifacts in images. While the best way to handle this is to use an external flash, Album Shaper provides a clever eye detection and red eye removal tool to fix red-eye problems in photos. Simply select each face region and click the <font color='red'>Red Eye</font> button.") << "\n";
    
    stream << "<p>" << HelpWindow::tr("Album Shaper can often find the red eyes when the entire image is selected, but to get the most accurate and fastest results, it is best to select the smallest area containing red eyes as possible.") << "\n";
    stream << "</td></tr></table>\n";
      
    stream << "</font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
