//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qfile.h>
#include <qtextstream.h>
#include <qstringlist.h>
#include <qnamespace.h>
#include <qkeysequence.h>

//Projectwide includes
#include "importing.h"
#include "helpWindow.h"
#include "../../config.h"

//==============================================
QString Importing::filename()
{
  return QString("%1/importing.html").arg(TEMP_DIR);
}
//==============================================
void Importing::generateHTML(QTextStream::Encoding type, QString charSet)
{
  QString finder  = HelpWindow::tr("the desktop or the Finder");
  QString exporer = HelpWindow::tr("the desktop or Windows Explorer");
  QString desktop = HelpWindow::tr("the desktop");
  
  QString dragLocation;
  QString ctrlKey;
#if defined(Q_OS_MACX)
  dragLocation = finder;
  ctrlKey = "Command";
#elif defined(Q_OS_WIN)
  dragLocation = exporer;
  ctrlKey = "Ctrl";
#else
  dragLocation = desktop;
  ctrlKey = "Ctrl";
#endif
  
  //create/open html file
  QFile file( filename() );
  if(file.open(IO_WriteOnly))
  {
    //-----
    QTextStream stream;
    stream.setEncoding( type );
    stream.setDevice( &file );
    //-----
    stream << "<html><head>\n";
    stream << "<meta http-equiv='Content-Type' content='text/html; charset=" << charSet << "'>\n";
    stream << "</head><body>\n";
    stream << "<table cellpadding='4'><tr>\n";
    stream << "<td><img src='" << IMAGE_PATH << "helpImages/asHelpLogoSmall.png'></td>\n";
    stream << "<td valign='middle'><font face='Arial, sans-serif' size='+3'>";
    stream << HelpWindow::tr("Importing & Organizing") << "</font></td>\n";
    stream << "</tr></table>\n";

    stream << "<font face='Arial, sans-serif'>\n";
    stream << "<table cellspacing='10' cellpadding='0'><tr><td>\n";
    
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Albums, Collections, and Photos:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
      
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("Album Shaper lets you organize your photos into albums much as one does with film and traditional prints. Since photo albums are often created for more complex or longer events, such as multi-day trips, an additional level of organization (collections) has been added. Photo albums contain one or more collections, each of which can contain as many photos as you choose.") << "\n";
    stream << "</td></tr></table>\n";
        
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Importing:") <<"</b></font>\n";
    stream << "</td></tr></table>\n";
          
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("When you start Album Shaper, you are presented an empty album that contains a single, empty collection. A list of the album collections is shown on the left, while the majority of the screen is used to show the photos in the currently selected collection.") << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/newAlbum.png'>\n";
    stream << "</td></tr></table>\n";
              
    stream << "</td></tr><tr><td>\n";
              
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/addRemoveButtons.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("To add photos to your album, click the <font color='red'>Add Photo</font> button and select the photos you wish to insert. If you have already started labeling your photos by changing their filenames, check the <font color='red'>use filenames for descriptions</font> checkbox to automatically assign labels to your imported photos.") << "\n";
    stream << "</td></tr></table>\n";
                
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << QString(HelpWindow::tr("Alternatively, you can import photos by dragging them from %1 and dropping them on the organize view. Album Shaper makes extensive use of drag and drop throughout the album creation process.")).arg(dragLocation) << "\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/addingPhotos.png'>\n";
    stream << "</td></tr></table>\n";
                  
    stream << "</td></tr><tr><td>\n";
                  
    stream << "<table width='100%' cellpadding='4' cellspacing='0'><tr><td bgcolor='lightgray'>\n";
    stream << "<font size='+1'><b>" << HelpWindow::tr("Organizing:") << "</b></font>\n";
    stream << "</td></tr></table>\n";
                  
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/createCollection.png'>\n";
    stream << "</td><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("When imported, photos are always placed at the end of the currently selected collection. In order to create additional collections, click the <font color='red'>Create</font> button below the list of collections. The new collection will be automatically selected and ready for you to import photos. You can switch between collections by clicking a collection icon in this list.") << "\n";
    stream << "</td></tr></table>\n";
                    
    stream << "<table cellpadding='4' cellspacing='0'><tr><td valign='middle'>\n";
    stream << "<p align='justify'>\n";
    stream << QString(HelpWindow::tr("Photos can be rearranged within collections by selecting them, then dragging and dropping them on their intended placement. To select a range of photos, select the first photo, then, while holding the Shift key, select the last photo in a range. All photos in between should now be selected. You can add or remove photos individually from the selection by holding the %1 key while selecting photos.")).arg(ctrlKey) << "\n";
                        
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("In addition to moving photos within collections, photos can also be moved from one collection to another, using drag and drop. Collections themselves can be reordered within the collections listing using drag and drop as well.") << "\n";
                          
    stream << "</td><td valign='middle'>\n";
    stream << "<img src='" << IMAGE_PATH << "helpImages/multipleCollections.png'>\n";
    stream << "</td></tr></table>\n";
                          
    stream << "<p align='justify'>\n";
    stream << HelpWindow::tr("In order to remove one or more photos, simply select them and click the <font color='red'>Remove Photo</font> button. You can also remove entire collections at a time, using the <font color='red'>Delete</font> button at the bottom of the collections listing.") << "\n";
                          
    stream << "</td></tr></table>\n";
    
    stream << "</td></tr>\n";
    stream << "</table></font>\n";
    stream << "</body></html>\n";
    file.close();
  }
}
//==============================================
