//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_PHOTOSICONVIEW_H
#define GUI_PHOTOSICONVIEW_H

//--------------------
//forward declarations
class QPixmap;
class QPainter;
class PhotoPreviewWidget;
class QPaintEvent;
class PhotoDescEdit;
//--------------------

#include <qiconview.h>

//=====================================
/*! \brief Extension of iconview, used to list all photos in a subalbum. supports drag-n-drop within iconview.
 */
//=====================================
class PhotosIconView : public QIconView
{
Q_OBJECT

public:
  PhotosIconView( QWidget *parent );

  //returns the number of selected items
  int numSelected();
public slots:
  void clearPseudoSelection();
  void repaintGroup( QIconViewItem* pseudoSelection);
  //----------------------
signals:
  void itemHasMoved();
  void addPhotos(QStringList);

  //the following signals are emitted in response to key events
  void removeSelectedPhotos();
  void rotate90SelectedPhotos();
  void rotate270SelectedPhotos();
  void editSelectedPhoto();
//----------------------
protected:
  QDragObject *dragObject();
  void drawContents ( QPainter * p, int clipx, int clipy, int clipw, int cliph );
  void drawBackground( QPainter* p, const QRect& r);
  void contextMenuEvent ( QContextMenuEvent* e );
  void contentsMouseMoveEvent( QMouseEvent *e);
  void contentsMousePressEvent ( QMouseEvent * e );
  void keyPressEvent( QKeyEvent *e );
//----------------------
private slots:
  void setAlbumImage( );
  void setSubalbumImage( );
  void captureClick(QIconViewItem*, const QPoint&);
//--
private:
  void contentsDropEvent( QDropEvent *e );
  
  bool findNearestUnselectedPhoto( const QPoint &pos, QIconViewItem** nearestItem, bool &posIsleftOfItem );
  
  PhotoPreviewWidget* rightClickedPhoto;
  QPixmap* backgroundImage;
  QPixmap bufferPixmap;
  QPixmap* dragIcon;
  PhotoPreviewWidget* currentPseudoSelection;
  bool handCursorShown;
  QPoint dragStartPos;
  
  PhotoDescEdit* curPhotoDescEdit;
//----------------------
};
//======================

#endif //GUI_PHOTOSICONVIEW_H
