//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_SUBALBUMSICONVIEW_H
#define GUI_SUBALBUMSICONVIEW_H

//--------------------
//forward declarations
class QPixmap;
class QPainter;
class QDragObject;
class SubalbumPreviewWidget;
//--------------------

#include <qiconview.h>
#include <qapplication.h>

//=====================================
/*! \brief Extension of iconview, used to list all subalbums in album. Supports drag-n-drop within
iconview such that subalbums can be reordered, as well as dropping photos from subalbums to allow
photos to be moved from one subalbum to another.
 */
//=====================================
class SubalbumsIconView : public QIconView
{
Q_OBJECT

public:
  SubalbumsIconView( QWidget *parent );
  int getTextWidth();  
  
  QSize minimumSizeHint() const;
  QSize sizeHint() const;

//----------------------
signals:
  void itemHasMoved();
//----------------------
protected:
  void drawContents ( QPainter * p, int clipx, int clipy, int clipw, int cliph );
  QDragObject *dragObject();
  
  void contentsMousePressEvent( QMouseEvent * e );
  void contentsDragMoveEvent( QDragMoveEvent* e );
//----------------------
private slots:
  void repaintGroup( QIconViewItem* pseudoSelection);
  void clearPseudoSelection();
//--
private:
  void contentsDropEvent( QDropEvent *e );
  QPixmap bufferPixmap;
  QPoint dragStartPos;
  SubalbumPreviewWidget* currentPseudoSelection;
  
  //width allocated to iconview items text.
  //IconViewItems will request this value when running calcRect()
  int textWidth; 
//----------------------
};
//======================


#endif //GUI_SUBALBUMSICONVIEW_H
