// ---------------------------------------------------------------------------
// - Persist.hpp                                                            -
// - aleph:odb library - persist class definition                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can rodbstribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_PERSIST_HPP
#define  ALEPH_PERSIST_HPP

#ifndef  ALEPH_SERIAL_HPP
#include "Serial.hpp"
#endif

namespace aleph {

  /// The Persist class is a base class for the aleph object database 
  /// system The class defines the  methods that are used to read of write 
  /// a particular persistent object. When saving, the object name is 
  /// retreived with the get name method. The saveas method does the same as 
  /// save but takes a file name argument.
  /// @author amaury darsch

  class Persist : public Serial {
  public:
    /// @return the persist name
    virtual String getname (void) const =0;

    /// save the persistent object to a file
    virtual void save (void) const;

    /// save the persistent object by name
    virtual void saveas (const String& name) const;    

    /// apply this persist with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
