# Dumb spellchecker for Alicq IM. Uses ispell -a mode.
# Author Ihar Viarheichyk

# TODO:
# 1. Check only changed text regions.
# 2. Get available languages from sender and receiver's whitepages info.
# 3. Make global dictionary change available immediately wthout reopening chat # window

# Default color for words with errors is red
option add *Text.mistakeColor red widgetDefault

# Generate list of available dictionaries on the fly.
proc AvailableDictionaries {} {
	set res [list "(none)"]
	set name ispell
	foreach x [split $::env(PATH) :] {
		if {[file executable [file join $x $name]]} {
			foreach d [lsort [glob -nocomplain [file join\
						$x .. lib $name *.hash]]] {
				lappend res [file root [file tail $d]]
			}
		}
	}
	set res
}

namespace eval meta {
	set description "Spell checking of outgoing messages via ispell"
	set author "Ihar Viarheichyk <iverg@mail.ru>"
	set capabilities {UI unloadable}

	array set dictionary [list\
		type variant save change description "Default dictionary"\
		valuescript [namespace parent]::AvailableDictionaries]
}

set ref [ref Contact]::meta
namespace eval $ref {
	array set dictionary {type variant save change 
		menu {"Spelling Dictionary"}}
}
set ${ref}::dictionary(valuescript) [namespace current]::AvailableDictionaries

# Bind contact default dictionary to global dictionary
upvar #0  ${ref}::dictionary(default) [namespace current]::dictionary

# Set default dictionary
foreach x [list $ref meta] { 
	set ${x}::dictionary(default) [lindex [AvailableDictionaries] 0]
}	

# Initialize dictionary specified by name. Returns file descriptor of ispell
# pipe. Can throw exception in case of I/O or file errors.
proc Dictionary {name} {
	set fd [open "|ispell -a -d $name" a+] 
	fconfigure $fd -buffering none
	# Quick and dirty hack to handle dictionaries with encoding different 
	# from current locale. encoding array can be set in alicqrc file.
	# TODO: Add UI for this if someone is need it.
	variable encoding
	if {[info exists encoding($name)]} {
		fconfigure $fd -encoding $encoding($name)
	}
	if {[gets $fd line]>0} {
		Event Log {info ispell} "$name: $line"
	} else { return -code error "No such dictionary" }
	set fd
}

# Start spell checking after 1 second since last modification of text
proc Delayed {txt fd} {
	if {![modified $txt]} return
	modified $txt 0
	foreach x [list cancel 1000] { after $x [nc CheckAll $txt $fd] }
}

# Determine which language/dictionary is selected for specified UID.
proc Language {uid} {
	variable dictionary
	set ref [ref $uid]
	if {[info exists ${ref}(dictionary)]} {
		set ${ref}(dictionary)
	} else { set dictionary }
}

# Perform initial bindings when chat dialog is open. To minimize number of
# spawned ispell processes, several windows using same langugage share single
# open dictionary. ref counter is used to track dictionary usage.
handler ChatOpen Bindings {uid in out} {
	variable mapping
	trace variable [ref $uid](dictionary) w [nc DictionaryChanged $uid $out]
	set lang [Language $uid]
	if {$lang=="(none)"} return
	if {![info exists mapping($lang,fd)]} {
		if {[catch {set mapping($lang,fd) [Dictionary $lang]} r]} {
			Event Log {error ispell} "Can't initialize ispell for $lang: $r"
			return
		}
		set mapping($lang,count) 1
	} else { incr mapping($lang,count) }
	set mapping($out) $lang
	bind $out <<Modified>> [nc Delayed $out $mapping($lang,fd)]
	$out tag configure mistake -foreground\
		[option get $out mistakeColor MistakeColor]
	$out tag bind mistake <3> [nc ReplaceMenu %W current %X %Y]
	bind $out <<CorrectSpelling>> [nc ReplaceMenu %W insert]
	bind $out <<NextSpellingError>> [nc GoToError %W next]
	bind $out <<PrevSpellingError>> [nc GoToError %W prev]
}

proc DictionaryChanged {uid out ref field args} {
	upvar 1 ${ref}($field) dictionary
	Close $uid _ $out
	$out tag delete mistake
	Bindings $uid _ $out
	modified $out 1
}

# Clean window-dictionary mapping. Close unused dictionary if needed.
handler ChatClose Close {uid in out} {
	variable mapping
	if {![info exists mapping($out)]} return
	set lang $mapping($out)
	unset mapping($out)
	variable mistakes-$out
	if {[info exists mistakes-$out]} { unset mistakes-$out }
	if {![incr mapping($lang,count) -1]} {
		close $mapping($lang,fd)
		array unset mapping $lang,*
	}
	bind $out <<Modified>> {}
	set var [ref $uid](dictionary)
	set cmd [nc DictionaryChanged $uid $out]
	foreach x [trace vinfo $var] {
		if {[lindex $x 1]==$cmd} { eval trace vdelete $var $x }
	}
}

# Create and display mistaken word replace menu
proc ReplaceMenu {txt index {x ""} {y ""}} {
	variable mistakes-$txt
	if {$index=="insert"} {
		if {[lsearch [$txt tag names $index] mistake]==-1} return
		$txt see $index
		foreach key {x y} val [lrange [$txt bbox $index] 0 1] {
			set $key [expr [winfo root$key $txt]+$val]
		}
		set index "$index +1 c"
	} elseif {$index!="current"} { 
		return -code error "$index mode is not implemented"
	}
	set word [eval $txt get [$txt tag prevrange mistake $index]]
	if {[winfo exists .mistake]} { destroy .mistake }
	menu .mistake -tearoff no
	.mistake add command -label "[mc Add] $word [mc {to dictionary}]"\
		-command [nc Add $txt $word]
	if {[info exists mistakes-${txt}($word)]} {
		.mistake add separator
		foreach to [set mistakes-${txt}($word)] {
			.mistake add command -label $to -command\
				[nc Replace $txt $word $to]
		}
	}
	tk_popup .mistake $x $y
}

# Move insertion cursor to the next spelling error forward or backward
proc GoToError {txt direction} {
	if {$direction=="prev"} { set op - } else { set op + } 
	set pos ""
	foreach {pos _} [$txt tag ${direction}range mistake insert] break
	if {$pos!="" && [lsearch [$txt tag names insert] mistake]!=-1}  {
		foreach {pos _} [$txt tag ${direction}range mistake\
			"$pos $op 1 c"] break
	}
	if {$pos!=""} { $txt mark set insert $pos }
}

# Replace word in a whole text and remove it from mistakes array.
proc Replace {txt word to} {
	variable mistakes-$txt
	if {[info exists mistakes-${txt}($word)]} {
		unset mistakes-${txt}($word)
	}	
	foreach {begin end} [$txt tag ranges mistake] {
		if {[$txt get $begin $end]==$word} {
			$txt delete $begin $end
			$txt insert $begin $to
		}
	}
}

# Add word into personal dictionary
proc Add {txt word} {
	variable mapping
	set lang $mapping($txt)
	puts $mapping($lang,fd) "*${word}\n#"
	# Replace word to itself to remove "mistake" tag
	Replace $txt $word $word 
}

# Dumb procedure which checks all words in a text widget against dictionary
# speficied by fd file descriptor. A lot of optimizations are possible here.
proc CheckAll {txt fd} {
	if {![winfo exists $txt]} return
	set from "1.0"
	while {[set from [$txt search -count l\
			-regexp {[[:alpha:]]+} $from end]]!={}} {
		set to [$txt index "$from + $l char"]
		set str [$txt get $from $to]
		if {$str!=""} {
			set cmd [expr {[WordExists $str $fd $txt]?"remove":"add"}]
			$txt tag $cmd mistake $from $to
		}
		set from $to
		update idletasks
	}
}

# Check if word exists in dicrionary fd. If word is illegal, a list of possible
# changes is moved into mistakes array. Mistakes are per-window.
proc WordExists {word fd txt} {
	variable mistakes-$txt
	if {[info exists mistakes-${txt}($word)]} { return 0 }
	puts $fd $word
	set text ""
	while {[gets $fd line]>0} {append text $line }
	if {[lsearch -exact {* + -} [string index $text 0]]!=-1} { return 1 }
	if {[string index $text 0]=="&"} {
		set i [expr [lindex $text 2]-1]
		set mistakes-${txt}($word) [lrange [string map {, ""} $text]\
			end-$i end]
	}
	return 0
}

# For compatibility with Tk 8.3 emulate <<Modified>> virtual event.
# This will not work for text inserted by other means, and not very efficient
# when <2> does not paste text or KeyPress does not change text.
if {[package vsatisfies [package present Tk] 8.4]} {
	proc modified {txt {val ""}} { eval $txt edit modified $val }
} else {
	proc modified {txt {val ""}} { 
		if {$val=="1"} { event generate $txt <<Modified>> }
		return 1 
	}
	event add <<Modified>> <KeyPress> <2>
	eval event add <<Modified>> [event info <<Paste>>]
}
event add <<CorrectSpelling>> <Control-s>
event add <<NextSpellingError>> <Control-n>
event add <<PrevSpellingError>> <Control-p>


