
option add *Authentication*borderWidth 1
option add *Authentication*highlightThickness 0
option add *Authentication*Entry.relief sunken
option add *Password.Label.anchor e
option add *Password.Entry.show *
option add *Password.Entry.validate key
option add *InProgress*borderWidth 1
option add *InProgress.btn.cancel.activeBackground red

proc Authentication {name cmd ext info {title "Authentication"}} {
	if {![catch {raise $name}]} return
	toplevel $name -class Authentication
	wm title $name $title
	message $name.info -text $info -aspect 600
	grid $name.info -row 0 -sticky we -ipadx 16 -ipady 4
	foreach x {1 2} { set [set v$x ::$name.pwd$x] 0}
	if {$ext!=""} {
		set ext [eval $ext $name.ext $v1]
		grid $ext -row 1 -sticky news -padx 8 -pady 20
	} else { unset $v1 }
	grid [frame $name.pwd -class Password] -padx 16 -row 2 -sticky we
	# Button bar
	grid [frame $name.btn] -sticky we -row 3
	button $name.btn.ok -text [mc Ok] -default active -state disabled\
		-command [list eval $cmd [list $name]\
		               "\[[list $name.pwd.en1] get\]"]
	button $name.btn.cancel -text [mc Cancel] -command [list destroy $name]
	grid $name.btn.ok $name.btn.cancel -padx 5 -pady 4
	grid columnconfigure $name 0 -weight 1
	grid rowconfigure $name 1 -weight 1

	foreach {x y} {1 Password 2 Verify} {
		label $name.pwd.lb$x -text [mc $y]
		entry $name.pwd.en$x -vcmd [nc ValidPassword $name.pwd $v2]
		grid $name.pwd.lb$x $name.pwd.en$x -sticky we -padx 4 -pady 3
	}
	grid columnconfigure $name.pwd 1 -weight 1
	set cmd [nc AllowOk $name.btn.ok $v1 $v2]
	# Set traces on indicator variables
	foreach x {1 2} {trace variable [set v$x] w $cmd}
	# Delete traces and variables
	bind $name.pwd <Destroy> "
		foreach x {1 2} {
			set v \[list %W\$x\]
			trace vdelete \$v w [list $cmd] 
			if {[info exists \$v]} {unset \$v}
		}
	"
	bind $name <Key-Return> [list $name.btn.ok invoke]
	set name
}

# Enable or disable Ok button according to indicator variables
proc AllowOk {btn a b args} {
	if {(![info exists $a]||[set $a])&&(![info exists $b]||[set $b])} {
		set state "normal"
	} else {set state "disabled" }
	$btn configure -state $state
}

# Check for password validity
proc ValidPassword {name var} {
	after idle [nc CheckPassword $name $var]
	return 1
}

# Real password validator
proc CheckPassword {name var} {
	foreach x {1 2} {set p$x [$name.en$x get]}
	set $var [expr [string equal $p1 $p2]&&[string length $p1]]
}

# ICQ-specifuc stuff
proc Ok_ICQ {status name pwd} {
	variable desiredStatus
	variable newLock
	set uin new
	if {[set ::$name.ext]=="specify"} {  set uin [$name.ext.en get] }
	destroy [winfo toplevel $name]
	if {$uin=="new"} {
		Event ICQ:Register $pwd
		set newLock [after 40000 [nc Timeout]]
	} else {
		set [pref "icq uin"] $uin
		set [pref "icq password"] $pwd
		if {$status && [info exists desiredStatus]} {
			Event SetStatus $desiredStatus
		}
	}
}

proc ChangePassword {name pwd} {
	variable pwdlist
	set ref [expr [clock seconds]&0xFF]
	set pwdlist($ref) $pwd
	destroy [winfo toplevel $name]
	Event ChangeICQPassword $pwd $ref
}

handler PasswordChanged ICQPasswordChanged {ref} {
	variable pwdlist
	if {[info exists pwdlist($ref)]} {
		set [pref "icq password"] $pwdlist($ref)
		unset pwdlist($ref)
		Event Notify "Password changed" "Your ICQ password was changed on server.\nNew password was written to your startup file as well."
	}
	if {![llength [array names pwdlist]]} { unset pwdlist }
}

proc Timeout {} {
	toplevel .regtimeout
	label .regtimeout.lb1 -bitmap info 
	label .regtimeout.lb2 -text\
		"No responce from server within a minute.\nPlease check network settings\n and try register new UIN again."
	button .regtimeout.b -text Close -command [list destroy .regtimeout]
	pack .regtimeout.lb1 .regtimeout.lb2 .regtimeout.b -pady 10 -padx 10
}

proc Proxy {proxy name var} { 
	frame $name
	label $name.lb -text [mc Login] -anchor e
	set textvar [winfo toplevel $name]:user
	set ref [ref Proxy:$proxy](user)
	if {[info exists $ref]} { set ::$textvar [set $ref] }
	entry $name.en -textvariable $textvar -validate key\
		-vcmd [nc isempty %P $var]
	$name.en validate	
	grid $name.lb $name.en -sticky we -padx 4
	grid columnconfigure $name 1 -weight 1
	set $var 1
	set name
}

proc isempty {val var} {
	set $var [expr {!($val=="")}]
	return 1
}

proc ProxyPassword {proxy name pwd} {
	variable desiredStatus
	array set [ref Proxy:$proxy] [list user [set ::${name}:user]\
		password $pwd]
	destroy [winfo toplevel $name]
	Event SetStatus $desiredStatus
}


proc ICQ {name var} {
	frame $name
	set uin [pref "icq uin"]
	radiobutton $name.r1 -value specify -text [mc "UIN is"] -variable $name\
		-command [nc SwitchState normal $var $name]
	entry $name.en -width 15 -validate key -vcmd [nc ValidUIN $var $name %P]
	if {[info exists $uin]} {$name.en insert 0 [set $uin]}
	bindtags $name.en [concat [bindtags $name.en] UIN]
	radiobutton $name.r2 -value new\
		-command [nc SwitchState disable $var $name]\
		-variable $name -text [mc "Register new UIN"]
	$name.r1 invoke
	grid $name.r1 $name.en -sticky w -padx 4
	grid $name.r2 -columnspan 2 -sticky w -padx 4
	bind $name <Destroy> { if {[info exists %W]} { unset %W } }
	set name
}

proc SwitchState {state var name} {
	$name.en configure -state $state
	CheckVar $var $name
}

proc ValidUIN {var name value} {
	after idle [nc CheckVar $var $name]
	string is digit $value
}

proc CheckVar {var name} {
	set $var [expr {[set ::$name]=="new" || [$name.en get]!=""}]
}

handler ConfigLoaded CheckAuth {args} {
	if {[lsearch [namespace children ::modules] *::icq]==-1} return
	set var [pref "icq uin"]
	if {![info exists $var] || ![string is digit -strict [set $var]]} {
		after idle [nc Authentication .auth [nc Ok_ICQ 0] ICQ [mc\
		   "You should have personal UIN to login to ICQ network"]]
		trace variable $var w [nc unlocker]
	}
}

handler SetStatus remember {status} {
	set [namespace current]::desiredStatus $status
} 0.1

handler Error:auth AuthError {reason} { 
	variable newLock
	if {[info exists newLock]} {
		append reason "\nRegistration of new UIN is in progress."
		append reason "\nPressing Ok button will cancel it."
	} 
	Authentication .auth [nc Ok_ICQ 1] ICQ $reason
}

proc unlocker {args} {
	variable newLock
	if {[info exists newLock]} { 
		after cancel $newLock
		unset newLock 
	}
	if {[winfo exists .auth]} { destroy .auth }
	if {[winfo exists .regtimeout]} { destroy .regtimeout }
}

handler {*|ChangePassword ChangePassword} ChangePasswordDlg {args} {
	Authentication .password [nc ChangePassword] {} "Type in your new ICQ password."
}

handler Error:proxy:auth ProxyAuth {proxy text} {
	Authentication .proxy-$proxy [nc ProxyPassword $proxy]\
		[list Proxy $proxy] "$text for proxy $proxy"
}

