#  Alicq ICQ client: sound notification module 
#  Copyright (C) Ihar Viarheichyk 2001

#  This module is a part of Alicq ICQ client.

variable players {auplay esdplay artsplay bplay play aplay}

namespace eval meta {
	set author "Ihar Viarheichyk <iverg@mail.ru>"
	set description "Basic implementation of sound notifications."
	array set player {description "External player" save change}
}

# Search by the list of well-known unix players in the path
proc FindExternalPlayer {} {
	variable player
	variable players
	if {[set x [External $players]]!=""} {
		set player $x
		Event Log info "Found external player $player"
		return 1
	} else { return 0 }
}

proc ExternalPlayer {} {
	proc ::load_sounds {name file} "
		set [namespace current]::sound_mapping(\$name) \$file
	"
	proc play {name} {
		variable sound_mapping
		variable player
		if {$player!="" && [info exists sound_mapping($name)]} {
			exec $player $sound_mapping($name) &
		}
	}
}

proc InternalPlayer {} {
	proc ::load_sounds {name file} { snack::sound sound:$name -file $file }
	proc play {name} { sound:$name play -blocking no }
	append meta::player(description) "\n(snack is in use now, external player will be available after Alicq reload)"
}

handler ConfigLoaded onConfig {args} {
	variable player
	if {![info exists player] || $player==""} {
		# If no external player specified, trying to load snack
		if {[catch { package require Ssnack } reason]} {
			Event Log error "Snack loading error: $reason"
			# Snack was not loaded, try to find external player
			# automatically
			if {$::tcl_platform(platform)=="unix" &&
			    [FindExternalPlayer]} { ExternalPlayer }
		} else { InternalPlayer }
	} else { ExternalPlayer }
	if {[llength [info procs ::load_sounds]]} {
		resource sounds {Message Auth}
		handler Incoming PlaySound {type args} {
			set snd Message
			if {$type=="authorization"} {set snd Auth}
			catch { play $snd }
		}
	}
}

