package require Tk
package require BWidget

option add *Info.Menubutton.background gray90 widgetDefault
option add *Info.Listbox.background gray90 widgetDefault
option add *Info.Menubutton.relief sunken widgetDefault
option add *Info.Menubutton.anchor w widgetDefault
option add *Info.Label.anchor e widgetDefault
option add *Info.Text.height 7 widgetDefault
option add *Info.Text.width 40 widgetDefault
option add *Info.Text.wrap word widgetDefault

namespace eval map {}
set map::Sex [list (Unset) Female Male]
set map::Language {(Unset) Arabic Bhojpuri Bulgarian Burmese Cantonese Catalan 
		Chinese Croatian Czech Danish Dutch English Esperanto
		Estonian Farsi Finnish French Gaelic German Greek Hebrew
		Hindi Hungarian Icelandic Indonesian Italian Japanese Khmer
		Korean Lao Latvian Lithuanian Malay Norwegian Polish
		Portuguese Romanian Russian Serbian Slovak Slovenian Somali
		Spanish Swahili Swedish Tagalog Tatar Thai Turkish Ukrainian
		Urdu Vietnamese Yiddish Yoruba Afrikaans Bosnian Persian
		Albanian Armenian Punjabi Chamorro Mongolian Mandarin
		Taiwaness Macedonian Sindhi Welsh Azerbaijani Kurdish Gujarati
		Tamil Belarusian Unknown
		}

set map::Month [list "(Unset)"]
for {set i 1} {$i<=12} {incr i} {
	lappend map::Month [clock format [clock scan "$i/01"] -format "%B"]
}

array set map::Country { 
	0 (Unset) 1 USA 7 Russia 20 Egypt 27 {South Africa} 30 Greece 31 Netherlands
	32 Belgium 33 France 34 Spain 36 Hungary 38 Yugoslavia
	39 Italy 40 Romania 41 Switzerland 42 {Czech Republic} 43 Austria
	44 UK 45 Denmark 46 Sweden 47 Norway 48 Poland 49 Germany 51 Peru 
	52 Mexico 53 Cuba 54 Argentina 55 Brazil 56 Chile 57 Columbia 58 Venezuela
	60 Malaysia 61 Australia 62 Indonesia 63 Philippines 64 {New Zealand}
	65 Singapore 66 Thailand 81 Japan 82 {South Korea} 84 Vietnam 86 China
	90 Turkey 91 India 92 Pakistan 93 Afghanistan 94 {Sri Lanka} 95 Myanmar
	98 Iran 101 Anguilla 102 Antigua 103 Bahamas 104 Barbados 105 Bermuda 
	106 {British Virgin Islands} 107 Canada 108 {Cayman Islands} 109 Dominica
	110 {Dominican Republic} 111 Grenada 112 Jamaica 113 Montserrat 114 Nevis 
	115 {St. Kitts} 116 {St. Vincent and the Grenadines} 
	117 {Trinidad and Tobago} 118 {Turks and Caicos Islands} 120 Barbuda
	121 {Puerto Rico} 122 {Saint Lucia} 123 {US Virgin Islands}
	212 Morocco 213 Algeria 216 Tunisia 218 Libya 221 Senegal 223 Mali 
	224 Guinea 225 {Ivory Coast} 226 {Burkina Faso} 227 Niger 228 Togo
	229 Benin 230 Mauritius 231 Liberia 232 {Sierra Leone} 233 Ghana
	234 Nigeria 235 Chad 236 {Central African Republic} 237 Cameroon
	238 {Cape Verde Islands} 239 {Sao Tome and Principe} 240 {Equatorial Guinea}
	241 Gabon 242 Congo 243 Zaire 244 Angola 245 Guinea-Bissau
	246 {Diego Garcia} 247 {Ascension Island} 248 {Seychelle Islands} 249 Sudan
	250 Rwanda 251 Ethiopia 252 Somalia 253 Djibouti 254 Kenya 255 Tanzania
	256 Uganda 257 Burundi 258 Mozambique 260 Zambia 261 Madagascar
	262 {Reunion Island} 263 Zimbabwe 264 Namibia 265 Malawi 266 Lesotho
	267 Botswana 268 Swaziland 269 {Mayotte Island} 290 {St. Helena}
	291 Eritrea 297 Aruba 297 {Faeroe Islands} 299 Greenland 350 Gibraltar
	351 Portugal 352 Luxembourg 353 Ireland 354 Iceland 356 Malta 357 Cyprus
	358 Finland 359 Bulgaria 370 Lithuania 371 Latvia 372 Estonia 373 Moldova
	374 Armenia 375 Belarus 376 Andorra 377 Monaco 371 {San Marino}
	379 {Vatican City} 380 Ukraine 381 Yugoslavia 385 Croatia 386 Slovenia
	387 {Bosnia and Herzegovina} 389 Macedonia 500 {Falkland Islands}
	501 Belize 502 Guatemala 503 {El Salvador} 504 Honduras 505 Nicaragua
	506 {Costa Rice} 507 Panama 508 {St. Pierre and Miquelon} 509 Haiti
	590 Guadeloupe 591 Bolivia 592 Guyana 593 Ecuador 594 {French Guiana}
	595 Paraguay 596 {French Antilles} 597 Suriname 598 Uruguay 
	599 {Netherlands Antilles} 670 Saipan 671 Guam 672 {Christmas Island}
	673 Brunei 674 Nauru 675 {Papua New Guinea} 676 Tonga 677 {Solomon Islands}
	678 Vanuatu 679 Fiji 680 Palau 681 {Wallis and Futuna Islands}
	682 {Cook Islands} 683 Niue 684 {American Samoa} 685 {Western Samoa}
	686 Kiribati 687 {New Caledonia} 688 Tuvalu 689 {French Polynesia}
	690 Tokelau 691 Micronesia 692 {Marshall Islands} 705 Kazakhstan
	706 {Kyrgyz Republic} 708 Tajikistan 709 Turkmenistan 711 Uzbekistan
	850 {North Korea} 852 {Hong Kong} 853 Macau 855 Cambodia 856 Laos
	868 {Trinidad and Tobago} 880 Bangladesh 886 Taiwan 960 Maldives
	961 Lebanon 962 Jordan 963 Syria 964 Iraq 965 Kuwait 966 {Saudia Arabia}
	967 Yemen 968 Oman 971 {United Arab Emirates} 972 Israel 973 Bahrain
	974 Qatar 975 Bhutan 976 Mongolia 977 Nepal 994 Azerbaijan 995 Georgia
	4101 Liechtenstein 4201 {Slovak Republic} 65535 {Not entered}
} 
array set map::TimeZone {0 {0 (Greenwich)} 
		1  {-0030} 2  {-0100} 3  {-0130} 4  {-0200} 
		5  {-0230} 6  {-0300} 7  {-0330} 8  {-0400}
		9  {-0430} 10 {-0500} 11 {-0530} 12 {-0600} 
		13 {-0630} 14 {-0700} 15 {-0730} 16 {-0800} 
		17 {-0900} 18 {-0930} 19 {-1000} 20 {-1030}
		21 {-1100} 22 {-1130}
		-1  {+0030} -2  {+0100} -3  {+0130} -4  {+0200}
		-5  {+0230} -6  {+0300} -7  {+0330} -8  {+0400}
		-9  {+0430} -10 {+0500} -11 {+0530} -12 {+0600}
		-13 {+0630} -14 {+0700} -15 {+0730} -16 {+0800} 
		-17 {+0900} -18 {+0930} -19 {+1000} -20 {+1030} 
		-21 {+1100} -22 {+1130}
}


set SearchLayout {
	{ {Nick Nick} {Email E-Mail} }
	{ {FirstName "First Name"} {LastName "Last Name"} }
	{ {Country Country} {City City} }
	{ {Sex Sex} {Language Language} }
	{ {OnlineOnly " "} }
}	

set InfoLayout {
 Main { { {Nick Nick} {UIN "ICQ UIN" ro} }
	{ {FirstName "First name"} {LastName "Last name"} }
	{ {email "e-Mail 1"} {email1 "e-Mail 2"}}
	{ {email2 "e-Mail 3"} {email3 "e-Mail 4"}}
	{ {Homepage "Home page" "" 3}}
      }
Where { { {Country Country} {City City}}
  	{ {State State} {Zip "Zip code"}}
  	{ {Street Address "" 3}}
  	{ {Phone Phone} {Fax Fax}}
  	{ {Mobile "Cell phone"} {TimeZone "Time zone"}}
      }
 More { { {Sex Sex} {Age Age} }
 	{ {"" Birthday} {"" Languages} }
	{ {Day Day} {Lang1 " " Language}}
	{ {Month Month} {Lang2 " " Language}}
	{ {Year Year} {Lang3 " " Language}}
      }
 About { { {About ""} }
 }
 ICQ {  { {Status Status tro} {IP "IP address" ro}}
 	{ {DC:type "Direct connections" tro} {LocalIP "DC IP Address" ro}}
	{ {client:client Client ro} { client:protocol "Protocol version" ro}}
	{ {Capabilities Capabilities ro 3} }
 }
}

proc Dialog {name var layout {prefix widget}} {
	frame $name -class Info 
	set row 1
	foreach line $layout {
		set col 0
		foreach item $line {
			foreach {id label type span} $item break
			set wid $row-$col
			if {$label!=""} {
				grid [label $name.lb$wid -text [mc $label]]\
					-row $row -column [incr col]\
					-sticky we -padx 2
			}
			if {$id==""} {
				grid configure $name.lb$wid -columnspan 2
				incr col
				continue
			}
			if {$type==""} { set type $id }
			set cmd $prefix:$type
			if {[info commands $cmd]!=$cmd} { set cmd $prefix:entry}
			if {[info commands $cmd]!=$cmd} continue
			grid [$cmd $name.en$wid ${var}($id)] -row $row\
				-column [incr col] -sticky we -padx 2 -pady 2
			grid columnconfigure $name $col -weight 1
			if {$span!=""} {
				grid configure $name.en$wid -columnspan $span
				incr col $span
			}	
		}
		incr row
	}
	set name
}

namespace eval info {}
variable is_offline 1

handler {Contact:ICQ:*|info:view info:update} View {{uid Me}} {
	set top .info-$uid
	if {$uid=="Me"} {
		variable uin
		set uid Contact:ICQ:$uin
		set ro widget
	} else { set ro ro }
	if {[winfo exists $top]} { raise $top; focus $top; return }
	toplevel $top -class AlicqInfoWindow
	bindtags $top [concat [bindtags $top] SaveGeometry]
	wm title $top "[mc {Information about}] [get $uid Alias]"
	variable InfoLayout
	for {set req 1} {$req<=100} {incr req} {
		if {![info exists info::$req]} break
	}
	if {$req==100} {
		Event Log error "Can not allocat request number"
		return
	}
	set var [namespace current]::info::$req
	grid [set nb [NoteBook $top.nb]] -sticky news -padx 4 -pady 2
	foreach {page layout} $InfoLayout {
		set f [$nb insert end $page -text [mc $page]]
		grid [Dialog $f.content $var $layout $ro] -sticky news
		foreach x {row column} { grid ${x}configure $f 0 -weight 1 }
	}
	foreach x {row column} { grid ${x}configure $top 0 -weight 1 }
	$nb raise [$nb pages 0]
	grid [label $top.status -textvariable ${var}(dialog:status)]\
		-sticky we -padx 4 -pady 4
	grid [frame $top.btn -class ButtonBar] -sticky we -padx 4 -pady 4
	grid columnconfigure $top.btn 0 -weight 1
	button $top.btn.close  -command [list destroy $top]
	bind $top.btn.close <Destroy> [list unset $var]
	grid $top.btn.close -row 0 -column 10 -sticky e -padx 2
	if {$ro=="widget"} {
		button $top.btn.update -text [mc Update]\
			-command [nc Update $uid $var]
		grid $top.btn.update -row 0 -column 1 -sticky e -padx 2
		ConfigureUpdateButton
	}

	set ref [ref $uid]
	if {[info exists ${ref}(Client)]} {
		foreach x {protocol client unicode} y [set ${ref}(Client)] {
			set ${var}(client:$x) $y
		}
	}
	foreach x {Status Capabilities IP LocalIP DC:type} {
		if {[info exists ${ref}($x)]} { set ${var}($x) [set ${ref}($x)]}
	}
	set ${var}(UIN) [lindex [split $uid :] end]
	update idletasks
	ConfigureWP $var
}

handler Info MapInfo {req info} {
	if {[info exists info::$req]} { 
		array set [namespace current]::info::$req $info
		set info::${req}(dialog:status) ""
	}
}

handler PersonalInfoUpdated AllowUpdate {req class} {
	if {[winfo exists .info-Me.btn.update]} {
		.info-Me.btn.update configure -state normal
		set [.info-Me.status cget -textvariable] ""
	}
}

proc Update {uid var}  {
	Event UpdateInfo [array get $var]
	set ${var}(dialog:status) [mc "Updating..."]
	.info-Me.btn.update configure -state disabled
}

proc AccessibleWP {ref field op} {
	variable is_offline
	set current [expr {[set [ref Me](Status)]=="offline"}]
	if {$current!=$is_offline} {
		set is_offline $current
		if {[winfo exists .info-Me]} { ConfigureUpdateButton }
		if {[winfo exists .search]} { IsSearchAllowed .search }
		foreach x [info vars info::*] { ConfigureWP $x }
	}
}

proc ConfigureUpdateButton {} {
	variable is_offline
	.info-Me.btn.update configure\
		-state [expr {$is_offline?"disabled":"normal"}]
}

proc ConfigureWP {var} {
	upvar 1 $var info
	variable is_offline
	if {$is_offline} {
		set str "Information is not available when offline"
	} else {
		set req [namespace tail $var]
		Event InfoRequest Contact:ICQ:$info(UIN) $req
		set str [mc "Quering information from server..."]
	}
	set info(dialog:status) [mc $str]
}

proc Search {args} {
	set top .search
	if {[winfo exists $top]} { raise $top; focus $top; return }

	toplevel $top -class AlicqSearchWindow
	bindtags $top [concat [bindtags $top] SaveGeometry]
	wm title $top [mc "Search in ICQ White Pages"]
	set var [namespace current]::query
	variable SearchLayout
	grid [Dialog $top.query $var $SearchLayout]\
		-sticky news -padx 2 -pady 2 -columnspan 2
	grid [ListBox $top.result -yscrollcommand [list $top.sb set]\
		-deltay [expr [image height img:offline]+2] -selectmode single]\
			-sticky news -padx 2 -pady 2 -row 3 -column 0
	bind $top <KeyPress-Up> [nc Navigate $top.result -1]		
	bind $top <KeyPress-Down> [nc Navigate $top.result 1]		
	grid [scrollbar $top.sb -orient vertical -command [list $top.result yview]] -sticky ns -row 3 -column 1
	grid rowconfigure $top 3 -weight 1
	grid columnconfigure $top 0 -weight 1
	grid [label $top.status] -sticky we
	grid [set btn [frame $top.btn -class ButtonBar]]\
		-sticky we -columnspan 2
	foreach x {1 10} { grid columnconfigure $btn $x -weight 1 }
	button $btn.more -text [mc Info] -state disabled -command\
		[nc MoreInfo $top.result]
	bind $top.result.c <Double-1> [list $btn.more invoke]
	button $btn.add -text [mc "Add"] -state disabled -command\
		[nc AddContact $top.result]
	button $btn.close -command [list destroy $top]
	button $btn.search -text [mc "Search"] -default active -command\
		[nc SearchRun $top.result $top.status\
			[list $btn.more $btn.add] $var]
	bind $top <<Accept>> [list $btn.search invoke]		
	bind $top <<Close>> [list $btn.close invoke]
	grid $btn.search x $btn.more $btn.add -padx 2 -pady 2 -sticky w -row 0
	grid $btn.close -row 0 -padx 2 -column 11
	set id [hook SearchResults [nc SearchResults $top.result $top.status\
		[list $btn.more $btn.add]]]
	IsSearchAllowed $top
	bind $top.result <Destroy> [nc CloseSearch $id $var]
}

proc Navigate {list adder} {
	set idx [$list selection get]
	if {$idx==""} return
	set idx [expr [$list index $idx] + $adder] 
	if {[set item [$list items $idx]]!=""} { 
		$list selection set $item 
		$list see $item
	}
}

# Disable "search" and "more info" buttons when status chenged to "offline",
# enable if status is online
proc IsSearchAllowed {top} {
	variable is_offline
	# Disable search button if status is offline
	$top.btn.search configure\
		-state [expr {$is_offline?"disabled":"normal"}]
	# Disable "more info" button when offline, set it according to
	# numbers of items in result list
	if {$is_offline} {
		$top.btn.more configure -state disabled
		# If search is in progress, stop it
		if {[$top.result cget -cursor]=="watch"} {
			$top.result configure -cursor {}
		}
		$top.status configure -text\
			[mc "Search is not available when offline"]
	} else {
		if {[$top.result index end]>=0} { 
			$top.btn.more configure -state normal 
		}
		$top.status configure -text ""
	}
}

# Remove hooks and traces used by search dialog
proc CloseSearch {id var} {
	unhook $id
	if {[info exists $var]} { unset $var }
}

# Start searching
# TODO: Add progress bar for search status
proc SearchRun {result status to_disable var} {
	$result delete [$result items]
	$result configure -cursor watch
	foreach widget $to_disable { $widget configure -state disabled }
	$status configure -text [mc "Searching..."]
	Event search [array get $var]
}

resource icons {invisible offline online}
# Display search results
proc SearchResults {result status to_allow Ref Info} {
	if {$Info=={}} { 
		$result configure -cursor {}
		$status configure -text [mc "Search complete"]
		return 
	}
	array set user $Info
	foreach widget $to_allow { $widget configure -state normal }
	if {$user(Nick)==""} {
		set nick ""
		set alias $user(UIN)
	} else { 
		set nick \"$user(Nick)\"
		set alias $user(Nick)
	}
	set nick [concat $user(FirstName) $nick $user(LastName)]
	set line [format "%12d    " $user(UIN)]
	if {$nick!=""} { append line $nick} 
	if {$user(email)!=""} { append line " <$user(email)>" }
	$result insert end $user(UIN) -text $line -data [list Alias $alias]
	set img img:$user(Status)
	if {[lsearch [image names] $img]} {
		$result itemconfigure $user(UIN) -image $img
	}
	if {[$result selection get]==""} { $result selection set $user(UIN) }
	unset user
}

# Require more info on selectied items
proc MoreInfo {result} {
	foreach x [$result selection get] {
		set uid Contact:ICQ:$x
		Event $uid|info:view $uid
	}
}

# Add contact to contact list
proc AddContact {result} {
	foreach x [$result selection get] {
		set aux [$result itemcget $x -data]
		if {[Event AddItem Contact:ICQ $x [lindex $aux end]]==""} {
			new Contact:ICQ:$x $aux
		}
	}
}

if [package vsatisfies [package present Tk] 8.4] {
  proc roentry {name args} { eval [list entry $name -state readonly] $args }
} else {
  proc roentry {name args} { eval [list entry $name -state disabled] $args }
}

proc IndirectMap {name var map} {
	roentry $name 
	trace variable $var w [nc IndirectAssign $name $map] 
	set name
}

proc IndirectAssign {widget mapper name field args} {
	upvar 1 $name info
	set val [mc [eval $mapper [list $info($field)]]]
	set state [$widget cget -state]
	$widget configure -state normal
	$widget delete 0
	$widget insert 0 $val
	$widget configure -state $state
}

proc Mapper {map idx} {
	if {[array exists $map]} {
		if {[info exists ${map}($idx)]} {
			return [set ${map}($idx)]
		} else { return Unknown }
	} elseif {[info exists $map]} {
		return [lindex [set $map] $idx]
	} else { return $idx }
}

proc widget:ro {name var} { roentry $name -textvariable $var }
proc widget:tro {name var} {IndirectMap $name $var {set ""} }
proc ro:tro {name var} {IndirectMap $name $var {set ""} }

proc ro:entry {name var} { widget:ro $name $var }

proc widget:entry {name var} { entry $name -textvariable $var }

proc widget:About {name var} { ui::text $name -variable $var }

proc ro:About {name var} { ui::text $name -variable $var  -state disabled }

proc widget:OnlineOnly {name var} {
	checkbutton $name -variable $var -text [mc "Only online contacts"]
}

set ns [namespace current]
foreach x [info vars map::*] {
	set name [namespace tail $x]
	interp alias {} ${ns}::widget:$name {} ${ns}::WidgetMap $x
	interp alias {} ${ns}::ro:$name {} ${ns}::RoMap $x
}

proc WidgetMap {map name var} {
	set vals [list]
	if {[array exists $map]} {
		set data [array get $map]
		set long [expr {[llength $data]/2>20}]
		foreach {x y} $data {
			set y [mc $y]
			if {$x && $long} { set y [string index $y 0]:$y }
			lappend vals [list $x $y]
		}
	} elseif {[info exists $map]} {
		set cnt -1
		set long [expr {[llength [set $map]]>20}]
		foreach x [set $map] { 
			set x [mc $x]
			if {$cnt>=0 && $long} { set x [string index $x 0]:$x }
			lappend vals [list [incr cnt] $x]
		}
	} else { return -code error "No map variable $map"}
	set $var 0
	ui::variant $name -variable $var -values [lsort -command valsort $vals]
}

proc RoMap {map name var} { IndirectMap $name $var [list Mapper $map] }

proc valsort {i1 i2} {
	string compare [lindex $i1 end] [lindex $i2 end]
}

proc MapToLocal {ext local args} {
	upvar #0 $ext [namespace current]::$local
	trace vdelete $ext w [nc MapToLocal $ext $local]
}
handler ConfigLoaded onConfig {args} {
	if {[lsearch [namespace children ::modules] *::icq]==-1} return
	set ext [pref "icq uin"]
	if {[info exists $ext]} {
		upvar #0 $ext [namespace current]::uin
	} else {
		trace variable $ext w [nc MapToLocal $ext uin]
	}
	trace variable [ref Me](Status) w [nc AccessibleWP]
}


namespace eval meta {
	set name "ICQ White Pages"
	set description "Search contacts view information on contacts and update personal information in ICQ White Pages "
	set author "Ihar iarheichyk <iverg@mail.ru>"
	set requires icq
	array set search {type action weight .1 script Search menu {Search "In ICQ White Pages"}}
	array set info:update {type action weight .2 menu {Change "Personal Info In ICQ White Pages"}}
}

namespace eval [ref Contact:ICQ]::meta {
	array set info:view [list type action menu Info\
		script [uplevel 1 namespace current]::View]
}

