package provide hooks 3.1

array set hooks [list]

# Hook management commands
proc hook {events script {priority 0.5} {filter 0}} {
	variable hooks
	if {$priority<0 || $priority>1} {
		return -code error "Priority should be in the range 0-1"
	} else {set priority [expr $priority]}
	if {![string is boolean $filter]} {
		return -code error "Filter should be boolean"
	} else { set filter [string is true $filter]}
	set id [lindex [lsort -integer [array names hooks]] end]
	if {$id==""} {set id 0} else {incr id}
	set hooks($id) [list $events $script $priority $filter]
	set id
}

proc unhook {args} {
	variable hooks
	if {[llength $args]==1} {
		foreach x [lindex $args 0] { 
			if {[info exists hooks($x)]} { unset hooks($x) }
		}
	} elseif {[llength $args]==2} {
		foreach {masks code} $args break
		foreach {id hook} [array get hooks] {
			foreach {events script prio filter} $hook break
			if {$code!=$script} continue
			foreach m $masks {
				if {[lsearch $events $m]!=-1} {
					unset hooks($id)
					break
				}
			}
		}
	} elseif {[llength $args]==0} { array set hooks [list] }
}

proc Event {name args} {
	variable hooks
	set queue [list]
	foreach {id hook} [array get hooks] {
		foreach {events script prio filter} $hook break
		foreach ev $events {
			if {[string match $ev $name]} {
				lappend queue [list $prio $script $filter]
				break
			}
		}
	}
	set chunk [list]
	foreach x [lsort -command sortEvents $queue] {
		lappend chunk [lindex $x 1] [lindex $x 2]
	}
	InvokeEvent $chunk $name $args
}

proc InvokeEvent {handlers name params} {
	set res ""
	foreach {handler filter} $handlers {
		set r [catch {set res [eval $handler $params]} v]
		if {[lsearch {0 2 3 4} $r]==-1} {
			if {$name!="Error:Module"} {
				Event Error:Module $handler $v
			}
			Event Log 0 "Error in $handler: $v\n$::errorInfo" 
		} elseif {$filter} {
			if {[llength $res]==[llength $params]} {
				set params $res
			} else {
				Event Error:Module $handler\
				   "Filter returned wrong number of arguments"
			}
		}
		switch -exact -- $r {
			0 -
			4 continue 
			default break
		}
	}
	set res
}

proc sortEvents {id1 id2} {
	set a [lindex $id1 0]
	set b [lindex $id2 0]
	expr {($a<$b)?-1:(($a==$b)?0:1)}
}

proc handler {events name arglist body {priority 0.5}} {
	set ns [uplevel 1 namespace current]
	proc ${ns}::$name $arglist $body
	hook $events ${ns}::$name $priority 0
}

proc filter {events name arglist body {priority 0.5}} {
	set ns [uplevel 1 namespace current]
	proc ${ns}::$name $arglist $body
	hook $events ${ns}::$name $priority 1
}

set flashcnt 0
proc Flash {type} {
	switch -- $type {
		more {if {[incr ::flashcnt]==1} {Flasher}}
		less {if {![incr ::flashcnt -1]} {
				after cancel $::flasher
				Event Flashing 1
			}	
		}
		* {return -code error "Unknown parameter $type for Flash"}
	}
}

proc Flasher {{stage 0}} {
	Event Flashing $stage
	set ::flasher [after 300 "Flasher [expr $stage^1]"]
}

