#!/bin/sh
#
# $Id: cmplhelp.sh 69 2006-06-05 23:22:41Z hubert@u.washington.edu $
#
#            T H E    P I N E    M A I L   S Y S T E M
#
#   Laurence Lundblade and Mike Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Building, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: lgl@CAC.Washington.EDU
#             mikes@CAC.Washington.EDU
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#
#   Pine and Pico are registered trademarks of the University of Washington.
#   No commercial use of these trademarks may be made without prior written
#   permission of the University of Washington.
#
#   Pine, Pico, and Pilot software and its included text are Copyright
#   1989-1996 by the University of Washington.
#
#   The full text of our legal notices is contained in the file called
#   CPYRIGHT, included with this distribution.
#
#
#   Pine is in part based on The Elm Mail System:
#    ***********************************************************************
#    *  The Elm Mail System  -  Revision: 2.13                             *
#    *                                                                     *
#    * 			Copyright (c) 1986, 1987 Dave Taylor               *
#    * 			Copyright (c) 1988, 1989 USENET Community Trust    *
#    ***********************************************************************
# 
#


# 
# cmplhelp.sh -- This script take the pine.hlp file and turns it into
# a .c file defining lots of strings
#

sed '
	s/\\"/-sed-backslash-quote-/g
	s/"/\\"/g
	s/-sed-backslash-quote-/\\"/g
    ' |

awk 'BEGIN         {in_text = 0;
                    count = 0;
		    first_one = 1;
                    printf("#include <stdio.h>\n#include \"headers.h\"\n#include \"../pith/helptext.h\"\n\n");
                   }


     //            { justtags = 0;}
     /^====/       { if(in_text)
                         printf("NULL\n};\n\n\n");
                     printf ("char *%s[] = {\n", $2 );
                     texts[count++] = $2;
                     in_text = 1;
		     new_topic = 1;
                    }
     /^$/           { if(in_text){
                          printf("\" \",\n");
                      }
                    }
     /^([ \t]*<[^<>]*>[ \t]*)*$/     { if(in_text) {
			  printf("\"%s\",\n", $0);
			  justtags = 1;
		      }
                    }
     /^[^=]/        { if(in_text) {
		        if(!justtags){
			  if(first_one){
			    first_one = 0;
			    print "/*";
			    print "TRANSLATORS: The translation strings for pith/helptext.c"
			    print "are automatically generated by a script from the help"
			    print "text in pith/pine.hlp. This means that the translation job for"
			    print "the help text is particularly difficult."
			    print "This is HTML source so please leave the text inside HTML tags untranslated."
			    print "HTML tags like <LI> or <TITLE> should, of course, be left untranslated."
			    print "Special HTML characters like &lt; (less than character) should be left alone."
			    print "Alpine option names are short phrases with the words separated by"
			    print "dashes. An example of an option name is Quell-Extra-Post-Prompt."
			    print "Option names should not be translated."
			    print "The file pith/helptext.c contains many separate help topics."
			    print "Some of them are very short and some are long. If left unsorted the"
			    print "text for a single topic is together in the translation file. The start"
			    print "of each new topic is marked by the comment"
			    print "TRANSLATORS: Start of new help topic."
			    print "*/";
			  }
			  else if(new_topic){
			    new_topic = 0;
			    print "/* TRANSLATORS: Start of new help topic. */"
			  }

		          printf("N_(\"%s\"),\n", $0);
		        }
		      }
                    }
     END            { if(in_text)
                          printf("NULL\n};\n\n");
                      printf("struct help_texts h_texts[] = {\n");
                      for(i = 0; i < count; i++)
                          printf("{%s,\"%s\"},\n",texts[i], texts[i]);
                      printf("{NO_HELP, NULL}\n};\n\n");
                    } '
