/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2002-2003 by Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: fixed_capacity_fwd.h,v 1.3 2004/03/16 15:12:25 wistaria Exp $ */

#ifndef ALPS_FIXED_CAPACITY_FWD_H
#define ALPS_FIXED_CAPACITY_FWD_H

#include <cstddef>

namespace alps {

namespace fixed_capacity {

// Forward declarations of checking policy classes
//   definitions are given in <alps/fixed_capacity/checking.h>

struct no_checking;
struct capacity_checking;
struct strict_checking;

} // namespace fixed_capacity

// Forward declarations of alps::fixed_capacity_[vector,deque]
//   definitions are given in <alps/fixed_capacity_vector.h> and
//   <alps/fixed_capacity_deque.h>, respectively

template<class T,
         std::size_t N,
         class CheckingPolicy = ::alps::fixed_capacity::no_checking>
class fixed_capacity_vector;
template<class T,
         std::size_t N,
         class CheckingPolicy = ::alps::fixed_capacity::no_checking>
class fixed_capacity_deque;

// Forward declaration of traits class alps::fixed_capacity_traits
//   definition is given in <alps/fixed_capacity_traits.h>

template<class C> struct fixed_capacity_traits;

} // namespace alps

#endif // ALPS_FIXED_CAPACITY_FWD_H
