/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2004 by Matthias Troyer <troyer@itp.phys.ethz.ch>,
*                            Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: parser.h,v 1.6 2004/10/12 17:14:00 troyer Exp $ */

#ifndef ALPS_PARSER_PARSER_H
#define ALPS_PARSER_PARSER_H

#include <alps/cctype.h>
#include <map>
#include <string>

namespace alps {

namespace detail {

inline bool is_identifier_char(char c) 
{ 
  return std::isalnum(c) || c=='_' || c=='\'' || c==':';
}

} // end namespace detail

extern std::string parse_identifier(std::istream& in);

extern std::string parse_parameter_name(std::istream& in);

extern std::string read_until(std::istream& in, char end);

extern void check_character(std::istream& in, char c, const std::string& err);

struct XMLTag
{
  XMLTag() {}
  typedef std::map<std::string,std::string> AttributeMap;
  std::string name;
  AttributeMap attributes;
  enum {OPENING, CLOSING, SINGLE, COMMENT, PROCESSING} type;
  bool is_comment() { return type==COMMENT;}
  bool is_processing() { return type==PROCESSING;}
  bool is_element() { return !is_comment() && !is_processing();}
};

XMLTag parse_tag(std::istream& p, bool skip_comments = false);

std::string parse_content(std::istream& in);

void skip_element(std::istream& in,const XMLTag&);

void check_tag(std::istream& in, const std::string& name);

} // end namespace alps

#endif // ALPS_PARSER_PARSER_H
