/*
 * Amanda, The Advanced Maryland Automatic Network Disk Archiver
 * Copyright (c) 1991-1998 University of Maryland at College Park
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of U.M. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  U.M. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * U.M. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL U.M.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: the Amanda Development Team.  Its members are listed in a
 * file named AUTHORS, in the root directory of this distribution.
 */
/* 
 * $Id: amandad.h,v 1.5 2006/07/19 17:46:07 martinea Exp $
 *
 */

#ifndef AMANDAD_UTIL_H
#define AMANDAD_UTIL_H

#include "amanda.h"
#include "amfeatures.h"
#include "sl.h"
#include "util.h"		/* for bstrncmp() */

#define DATA_FD_COUNT   3               /* number of general-use pipes */
#define DATA_FD_OFFSET  50  

typedef struct g_option_s {
    char *str;
    am_feature_t *features;
    char *hostname;
    char *auth;
    int maxdumps;
    char *config;
} g_option_t;


void init_g_options(g_option_t *g_options);
g_option_t *parse_g_options(char *str, int verbose);
void free_g_options(g_option_t *);

#endif
