/* $Id: wmchangabletitle.c,v 1.9 2000/03/03 18:39:07 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmain.h"
#include "wmtitle.h"
#include "wmclient.h"
#include "wmchangabletitle.h"

static void wm_chg_title_chilcked_signal(GtkWidget *widget, gpointer data);
static void wm_chg_title_entry_show     (GtkWidget *widget, gpointer data);
static void wm_chg_title_entry_set_focus(GtkWidget *widget);
static void wm_chg_title_entry_activate (GtkWidget *widget, gpointer client);
static void wm_chg_title_entry_activate2(GtkWidget *widget, gpointer chgBtn);

static void wm_chg_title_chilcked_signal(GtkWidget *widget, gpointer data)
{
    if(GTK_WIDGET_VISIBLE(GTK_WIDGET(data))) {
	gtk_widget_hide(GTK_WIDGET(data));
    } else {
	gtk_widget_show(GTK_WIDGET(data));
    }
}

static void wm_chg_title_entry_show(GtkWidget *widget, gpointer data)
{
    if(IS_WM_CLIENT(data)) {
	gtk_entry_set_text(GTK_ENTRY(widget), WM_CLIENT_TITLE_FORMAT(data));
	wm_chg_title_entry_set_focus(widget); /* ͭˤʤäƤʤ */
    }
}

static void wm_chg_title_entry_set_focus(GtkWidget *widget)
{
    /* ľ X Ȥ鷺ˤʤȤ */
    XSetInputFocus(GDK_DISPLAY(), WM_XWINDOW(widget),
		   RevertToPointerRoot, CurrentTime);
/*gtk_window_set_focus(GTK_WINDOW(gtk_widget_get_toplevel(widget)), widget); */
}


static void wm_chg_title_entry_activate(GtkWidget *widget, gpointer client)
{
    if(IS_WM_CLIENT(client)) {
	g_free(WM_CLIENT_TITLE_FORMAT(client));
	WM_CLIENT_TITLE_FORMAT(client) =
	    g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
	gtk_signal_emit_by_name(GTK_OBJECT(client), "title_change");
    }
}

static void wm_chg_title_entry_activate2(GtkWidget *widget, gpointer chgBtn)
{
    gtk_signal_emit_by_name(GTK_OBJECT(chgBtn), "clicked");
}

GtkWidget *wm_changable_title_button_new_default(GtkWidget *client)
{
    GtkWidget *title;
    GtkWidget *entry;
    GtkWidget *box;    /* title  entry 򤽤Τɬ (Thanx ¼) */
    GtkWidget *chgBtn;
    GtkWidget *chgTitle;

    wm_message("WmChangable: new default\n");

    title    = wm_title_button_new_default(client);
    entry    = gtk_entry_new();
    chgBtn   = gtk_button_new_with_label("<");
    chgTitle = gtk_hbox_new(FALSE, 0);
    box      = gtk_hbox_new(FALSE, 0);

    gtk_box_pack_start(GTK_BOX(box), title, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box), entry, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(chgTitle), box,    TRUE,  TRUE, 0);
    gtk_box_pack_end  (GTK_BOX(chgTitle), chgBtn, FALSE, TRUE, 0);

    gtk_widget_show(title);
    gtk_widget_show(chgBtn);
    gtk_widget_show(box);

    gtk_signal_connect(GTK_OBJECT(chgBtn), "clicked",
		       GTK_SIGNAL_FUNC(wm_chg_title_chilcked_signal),
		       (gpointer)title);
    gtk_signal_connect(GTK_OBJECT(chgBtn), "clicked",
		       GTK_SIGNAL_FUNC(wm_chg_title_chilcked_signal),
		       (gpointer)entry);
    gtk_signal_connect(GTK_OBJECT(entry), "show",
		       GTK_SIGNAL_FUNC(wm_chg_title_entry_show),
		       (gpointer)client);
    gtk_signal_connect_object(GTK_OBJECT(entry), "button_press_event",
			      GTK_SIGNAL_FUNC(wm_chg_title_entry_set_focus),
			      GTK_OBJECT(entry));
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(wm_chg_title_entry_activate),
		       (gpointer)client);
    gtk_signal_connect(GTK_OBJECT(entry), "activate",
		       GTK_SIGNAL_FUNC(wm_chg_title_entry_activate2),
		       (gpointer)chgBtn);
    return chgTitle;
}
