# $Id: Bitdefender.pm,v 1.3 2002/07/02 12:59:21 bengen Exp $

#
# Support module for Bitdefender
#

package AMAVIS::AV::Bitdefender;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_bitdefender_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Bitdefender';
  $cfg_bitdefender_binary = $AMAVIS::cfg->val('Bitdefender', 'bitdefender');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_bitdefender_binary eq '') {
    writelog($args,LOG_CRIT, "Path to Bitdefender not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_bitdefender_binary) {
    writelog($args,LOG_CRIT, "Bitdefender not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my ($no_infected, $no_suspect, $no_viruses);

  writelog($args,LOG_DEBUG,"Scanning with Bitdefender");
  writelog($args,LOG_DEBUG,
	   "Output from $cfg_bitdefender_binary $$args{directory}/parts");
  my $output_handle = cmd_pipe($args, $cfg_bitdefender_binary, 
# 			       '--pack',
# 			       '--hed',
# 			       '--auto',
			       "$$args{directory}/parts");
  while(<$output_handle>) {
    chomp;
    push @output, $_;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_bitdefender_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    writelog($args,LOG_ERR,"Virus scanner failure -- unknown reason.");
    return 0;
  }
  else {
    my %uniq;
    my @viruses;
    foreach (@output) {
      /^Infected files *:(\d+)/ && do {
	$no_infected=$1;
	next;
      };
      /^Suspect files *:(\d+)/ && do {
	$no_suspect=$1;
	next;
      };
      /^Identified viruses *:(\d+)/ && do {
	$no_viruses=$1;
	next;
      };
      /infected: (.*)\033/ && do {
	unless($uniq{$1}++) {
	  push @viruses, $1;
	}
      };
    }
    if ($no_infected or $no_suspect or $no_viruses) {
      push @{$$args{'found_viruses'}{'Bitdefender'}}, @viruses;
    }
  }
  # Return successfully...
  return 1;
}

1;
