# $Id: CLAM.pm,v 1.7 2003/03/31 03:09:02 bengen Exp $

#
# Module for CLAM Antivirus
#

package AMAVIS::AV::CLAM;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_clam_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'CLAM Anti Virus';
  $cfg_clam_binary = $AMAVIS::cfg->val('CLAM', 'clamscan');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_clam_binary eq '') {
    writelog($args,LOG_CRIT, __PACKAGE__.": path to CLAM not specified.");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_clam_binary) {
    writelog($args,LOG_CRIT, __PACKAGE__.": $cfg_clam_binary not executable.");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;
  my @command = ($cfg_clam_binary, 
		 '--stdout',
		 '--threads', '0',
		 '-r','-w',
		 "$$args{directory}/parts");

  writelog($args,LOG_DEBUG,"Scanning with CLAM.");
  writelog($args,LOG_DEBUG,
	   'Output from '.join(' ',@command));
  my $output_handle = cmd_pipe($args, @command)
    or do {
      writelog($args,LOG_ERR, __PACKAGE__.": Error running program $cfg_clam_binary - $!");
      return 0;
    };

  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG, $_);
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_clam_binary\n");

  $output_handle->close() or do {
    if ($!) {
      writelog($args,LOG_ERR, __PACKAGE__.
	       ": Error closing output from $cfg_clam_binary - $!");
      return 0;
    }
  };

  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval == 1) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /.*: (.+) FOUND/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'CLAM Anti Virus'}}, $1;
	  }
	}
      }
    } else {
      writelog($args,LOG_ERR, __PACKAGE__.": Virus scanner failure: $cfg_clam_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
