# $Id: Sophos.pm,v 1.12 2003/11/26 10:22:28 bengen Exp $

#
# Sophos Anti-Virus
#

package AMAVIS::AV::Sophos;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_sophos_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Sophos Anti-Virus';
  $cfg_sophos_binary = $AMAVIS::cfg->val('Sophos', 'sweep');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_sophos_binary eq '') {
    writelog($args,LOG_CRIT, "Path to Sophos not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_sophos_binary) {
    writelog($args,LOG_CRIT, "Sophos not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  # Return successfully
  return 1;
}

sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

  writelog($args,LOG_DEBUG,"Scanning with sophos");

  my $output_handle = cmd_pipe($args, $cfg_sophos_binary, 
			       # '-nb',
			       '-f',   # Full SWEEP (???)
			       # '-all', # SWEEP all files
			       # '-rec', # Do a recursive SWEEP
			       '-ss',  # Don't display anything except
                                       # on error or virus
			       '-sc',  # dynamically compressed archives
			       # '-archive',
			       "$$args{directory}/parts");
  
  writelog($args,LOG_DEBUG, "Begin output from $cfg_sophos_binary -nb -f -all -rec -ss -sc -archive $$args{directory}/parts"); 

  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    push @output, $_;
  }

  writelog($args,LOG_DEBUG, "End output from $cfg_sophos_binary");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  if ($errval != 0) {
    if ($errval == 3) {
      my %uniq;
      foreach my $output (@output) {
	if ( $output =~ /Virus(?: fragment)? \'(.+)\' found/g ) {
	  unless($uniq{$1}++) {
	    push @{$$args{'found_viruses'}{'Sophos Anti-Virus'}}, $1;
	  }
	}
      }
    } elsif ($errval == 2) {
      writelog($args,LOG_WARNING,"FIXME: Accorting to sweep manpage, \"some error preventing further execution is discovered\".");
    } else {
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_sophos_binary (error code: $errval)");
      # return ERROR
      return 0;
    }
  }
  # Return successfully
  return 1;
}

1;
