# $Id: Trend.pm,v 1.5 2002/11/18 14:13:57 bengen Exp $

#
# Trend code for virus scanners
#

package AMAVIS::AV::Trend;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_trend_binary
	    $cfg_chroot
	   );

sub init {
  my $self = shift;
  my $args = shift;
  push @{$$args{'virus_scanners'}}, 'Trend';
  $cfg_trend_binary = $AMAVIS::cfg->val('Trend', 'vscan');
  $cfg_chroot = $AMAVIS::cfg->val('security','chroot') || "";
  if ($cfg_trend_binary eq '') {
    writelog($args,LOG_CRIT, "Path to Trend not specified");
    return 0;
  }
  if (! -x $cfg_chroot.$cfg_trend_binary) {
    writelog($args,LOG_CRIT, "Trend not executable");
    return 0;
  }
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.\n");
  # Return successfully
  return 1;
}

# Called from AMAVIS.pm. Scanning takes place here.
sub scan {
  my $self = shift;
  my $args = shift;

  my @output;

  writelog($args,LOG_DEBUG,"Scanning with Trend");
  writelog($args,LOG_DEBUG,
	   "Output from ".join(' ',
			       $cfg_trend_binary,
			       '-a',
			       "$$args{directory}/parts"));
  my $output_handle = cmd_pipe($args, 
			       $cfg_trend_binary, 
			       '-a',
			       "$$args{directory}/parts");
  
  my $nbvirus = 0;
  while(<$output_handle>) {
    chomp;
    s/[\000-\037]*//g;
    writelog($args,LOG_DEBUG,$_);
    if (/Infected : ([1-9][0-9]*)\(/) {
      $nbvirus = $1;
    }
    push @output, $_;
  }
  writelog($args,LOG_DEBUG, "End output from $cfg_trend_binary\n");
  wait;
  my $errval = ($? >> 8);
  writelog($args,LOG_DEBUG,"Return code $errval");
  writelog($args,LOG_DEBUG,"Return Infected files (With compressed): $nbvirus");
  if ($nbvirus > 0) { # Virus found, return code probably null
    my %uniq;
    foreach my $output (@output) {
      if ( $output =~ /Found virus (.+) in/g ) {
	 unless($uniq{$1}++) {
	   push @{$$args{'found_viruses'}{'Trend'}}, $1;
	 }
      }
    } 
  } elsif ($errval != 0) { # No virus found, but with return code ... 
      writelog($args,LOG_ERR,"Virus scanner failure: $cfg_trend_binary (error code: $errval)");
      # return ERROR
      return 0;
  }

  # Return successfully...
  return 1;
}

1;
