# $Id: ARC.pm,v 1.10 2003/03/31 03:06:49 bengen Exp $

#
# Module for extracting ARC files
#

package AMAVIS::Extract::ARC;
use strict;

use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_arc_binary
	    $cfg_nomarch_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_arc_binary=$AMAVIS::cfg->val('external', 'arc');
  if (defined $cfg_arc_binary) {
    if (! -x  $cfg_arc_binary) {
      writelog($args,LOG_CRIT, __PACKAGE__.
	       ": ARC binary ($cfg_arc_binary) not executable");
      return 0;
    }
    $cfg_nomarch_binary=undef;
  }
  else {
    $cfg_nomarch_binary=$AMAVIS::cfg->val('external', 'nomarch');
    if (! -x  $cfg_nomarch_binary) {
      writelog($args,LOG_CRIT, __PACKAGE__.
	       ": NOMARCH binary ($cfg_nomarch_binary) not executable");
      return 0;
    }
  }
  $$types{'application/x-arc'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as ARC file");

  my $buffer;
  my $len;
  my @list;

  # Determine contents of archive...
  if (defined $cfg_nomarch_binary) {
    my $output_handle = cmd_pipe($args, $cfg_nomarch_binary,
			       '-l',
 			       "$$args{'directory'}/parts/$filename");

     while (<$output_handle>) {
       chop;
       my @vals = split(/\s+/);
       push @list, $vals[0];
     }
     $output_handle->close();
  }
  else {
    my $output_handle = cmd_pipe($args, $cfg_arc_binary,
			       'ln',
 			       "$$args{'directory'}/parts/$filename");

    while (<$output_handle>) {
      chop;
      push @list, $_;
    }
    $output_handle->close();
  }

  # Extract each file through a pipe. Slower but more secure.
  # FIXME: What about shell metacharacters and such?
  foreach (@list) {
    my $in_handle;

    unless (/.*\/$/) {		# Ignore directories
      if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
	return 0;
      }
      if (defined $cfg_nomarch_binary) {
        $in_handle=cmd_pipe($args, $cfg_nomarch_binary,
	  		     '-p',
	  		     "$$args{'directory'}/parts/$filename", $_);
      }
      else {
        $in_handle=cmd_pipe($args, $cfg_arc_binary,
	  		     'p',
	  		     "$$args{'directory'}/parts/$filename", $_);
      }
      my $securename=get_secure_filename($args);
      my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				   .$securename);
      while ($len=$in_handle->read($buffer, 4096)) {
	$out_handle->write($buffer, $len);
	$unpacked_size += $len;
	if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	  $in_handle->close();
	  $out_handle->close();
	  writelog($args,LOG_ERR, __PACKAGE__.
		   ": Unpacking takes too much space");
	  return 0;
	}
      }
      $in_handle->close();
      $out_handle->close();
      $ {$$args{'contents'}}{$securename} = {'original_filename' => $_};
      $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
    }
  }
  return 1;
}

1;
