# $Id: ARJ.pm,v 1.7 2003/03/31 06:06:35 bengen Exp $

package AMAVIS::Extract::ARJ;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_unarj_binary
	    $cfg_arj_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_unarj_binary=$AMAVIS::cfg->val('external', 'unarj');
  if (defined $cfg_unarj_binary) {
    if (! -x  $cfg_unarj_binary) {
      writelog($args,LOG_CRIT, __PACKAGE__.
	       ": UNARJ binary ($cfg_unarj_binary) not executable");
      return 0;
    }
    $cfg_arj_binary=undef;
    writelog($args,LOG_DEBUG, __PACKAGE__.": Using unarj ($cfg_unarj_binary)");
  }
  else {
    $cfg_arj_binary=$AMAVIS::cfg->val('external', 'arj');
    if (! -x  $cfg_arj_binary) {
      writelog($args,LOG_CRIT, __PACKAGE__.
	       ": ARJ binary ($cfg_arj_binary) not executable");
      return 0;
    }
    writelog($args,LOG_DEBUG, __PACKAGE__.": Using arj ($cfg_arj_binary)");
  }

  $$types{'application/x-arj'}=$self;
  writelog($args,LOG_DEBUG,__PACKAGE__." initialized.");
  return 1;
}

sub extract {
  my $self = shift;
  my $args = shift;
  my $filename = shift;

  # Work around DOSism braindamage in unarj.
  if ($filename !~ /.arj$/) {
    $filename.='.';
  }

  my $unpacked_size = 0;
  my @arj_filenames;
  my @command;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as ARJ file");

  if (defined $cfg_unarj_binary) {
    @command = ($cfg_unarj_binary,
		'l',
		"$$args{'directory'}/parts/$filename");
  } elsif (defined $cfg_arj_binary) {
    @command = ($cfg_arj_binary,
		'l',
		"$$args{'directory'}/parts/$filename");
  } else {
    return 0;
  }

  my $output_handle = cmd_pipe($args, @command);
  # Skip over 
  while(<$output_handle>) {
    last if (/^------------/);
  }
  while(<$output_handle>) {
    last if (/^------------/);
    (my $member) = /^(\S*)/;
    if (defined $cfg_unarj_binary) {
      # Work around broken behavior with case-sensitiveness.
      $member =~ tr [A-Z] [a-z];
    }
    push @arj_filenames,$member;
  }
  while(<$output_handle>) {
  }
  wait;

  foreach (@arj_filenames) {
    if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
      return 0;
    }

    if (defined $cfg_unarj_binary) {
      @command = ($cfg_unarj_binary,
		  'pq',
		  "$$args{'directory'}/parts/$filename",
		  $_);
    } elsif (defined $cfg_arj_binary) {
      @command = ($cfg_arj_binary,
		  'p',
		  "$$args{'directory'}/parts/$filename",
		  $_);
    } else {
      return 0;
    }

    writelog($args,LOG_DEBUG, join(' ',@command));
    my $in_handle=cmd_pipe($args, @command);
    my $securename=get_secure_filename($args);
    my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
				 .$securename);
    while (my $len=$in_handle->read(my $buffer, 4096)) {
      $out_handle->write($buffer, $len);
      $unpacked_size += $len;
      if ($$args{'unpacked_size'} + $unpacked_size >= $cfg_maxspace) {
	$in_handle->close();
	$out_handle->close();
	writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
	return 0;
      }
    }
    $in_handle->close();
    $out_handle->close();
    $ {$$args{'contents'}}{$securename} = {'original_filename' => $_};
    $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
  }
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
