# $Id: BZIP2.pm,v 1.8 2002/07/12 08:25:06 bengen Exp $

#
# Module for unpacking bzip2'd files.
#

package AMAVIS::Extract::BZIP2;
use strict;
use vars qw($VERSION);
$VERSION='0.1';

use AMAVIS;
use AMAVIS::Logging;

use vars qw(
	    $cfg_bzip2_binary
	   );

sub init {
  my $self = shift;
  my $args = shift;
  my $types = shift;
  $cfg_bzip2_binary=$AMAVIS::cfg->val('external', 'bzip2');
  if (! -x  $cfg_bzip2_binary) {
    writelog($args,LOG_CRIT, __PACKAGE__.
	     ": bzip2 binary ($cfg_bzip2_binary) not executable");
    return 0;
  }
  $$types{'application/x-bzip2'}=$self;
  writelog($args,LOG_DEBUG, __PACKAGE__." initialized.");
  return 1;
}

sub extract( $ ) {
  my $self = shift;
  my $args = shift;
  my $filename = shift;
  my $securename=get_secure_filename($args);
  my $unpacked_size = 0;

  writelog($args,LOG_DEBUG, "Attempting to unpack $filename as bzip2 file");

  if ($$args{'unpacked_files'}++ > $cfg_maxfiles) {
    writelog($args,LOG_ERR, __PACKAGE__.": Unpacking uses too many files");
    return 0;
  }

  my $in_handle = cmd_pipe($args, $cfg_bzip2_binary,
			   '-cd',
			   "$$args{'directory'}/parts/$filename");
  unless (defined $in_handle) {
    writelog($args,LOG_ERR, __PACKAGE__.": Error extracting file");
    return 0;
  }
  my $out_handle=IO::File->new(">$$args{'directory'}/parts/"
			       .$securename);
  unless (defined $out_handle) {
    writelog($args,LOG_ERR, __PACKAGE__.": Error extracting file");
    return 0;
  }

  while ((my $len=$in_handle->read(my $buffer, 4096)) > 0) {
    $out_handle->write($buffer, $len);
    $unpacked_size += $len;
    if ($$args{'unpacked_size'} + $unpacked_size > $cfg_maxspace) {
      $in_handle->close();
      $out_handle->close();
      writelog($args,LOG_ERR, __PACKAGE__.": Unpacking takes too much space");
      return 0;
    }
  }
	
  $in_handle->close();
  $out_handle->close();

  $ {$$args{'contents'}}{$securename} = {};
  $ {$ {$$args{'contents'}}{$securename}}{insecure_type}='';
  $$args{'unpacked_size'} += $unpacked_size;
  return 1;
}

1;
